/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.testing.integration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.sling.commons.testing.integration.HttpAnyMethod;
import org.apache.sling.commons.testing.integration.HttpStatusCodeException;
import org.apache.sling.commons.testing.integration.HttpTestBase;
import org.apache.sling.commons.testing.integration.NameValuePair;
import org.apache.sling.commons.testing.integration.NameValuePairList;

public class SlingIntegrationTestClient {
    private final HttpClient httpClient;

    public SlingIntegrationTestClient(HttpClient client) {
        this.httpClient = client;
    }

    public int upload(String toUrl, InputStream is) throws IOException {
        PutMethod put = new PutMethod(toUrl);
        put.setRequestEntity((RequestEntity)new InputStreamRequestEntity(is));
        return this.httpClient.executeMethod((HttpMethod)put);
    }

    public int delete(String url) throws IOException {
        DeleteMethod delete = new DeleteMethod(url);
        return this.httpClient.executeMethod((HttpMethod)delete);
    }

    public void mkdir(String url) throws IOException {
        int status = 0;
        status = this.httpClient.executeMethod((HttpMethod)new GetMethod(url + ".txt"));
        if (status != 200 && (status = this.httpClient.executeMethod((HttpMethod)new HttpAnyMethod("MKCOL", url))) != 201) {
            throw new IOException("mkdir(" + url + ") failed, status code=" + status);
        }
    }

    public void mkdirs(String baseUrl, String path) throws IOException {
        String[] paths = path.split("/");
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        String currentPath = baseUrl;
        for (String pathElement : paths) {
            if (pathElement.length() == 0) continue;
            currentPath = currentPath + "/" + pathElement;
            this.mkdir(currentPath);
        }
        String url = baseUrl + path;
        int status = this.httpClient.executeMethod((HttpMethod)new GetMethod(url + ".txt"));
        if (status != 200) {
            throw new HttpStatusCodeException(200, status, "GET", url);
        }
    }

    public String createNode(String url, Map<String, String> nodeProperties) throws IOException {
        return this.createNode(url, nodeProperties, null, false);
    }

    public String createNode(String url, Map<String, String> clientNodeProperties, Map<String, String> requestHeaders, boolean multiPart) throws IOException {
        return this.createNode(url, new NameValuePairList(clientNodeProperties), requestHeaders, multiPart);
    }

    public String createNode(String url, NameValuePairList clientNodeProperties, Map<String, String> requestHeaders, boolean multiPart) throws IOException {
        return this.createNode(url, clientNodeProperties, requestHeaders, multiPart, null, null, null);
    }

    public String createNode(String url, NameValuePairList clientNodeProperties, Map<String, String> requestHeaders, boolean multiPart, File localFile, String fieldName, String typeHint) throws IOException {
        PostMethod post = new PostMethod(url);
        post.setFollowRedirects(false);
        NameValuePairList nodeProperties = new NameValuePairList(clientNodeProperties);
        nodeProperties.prependIfNew(":redirect", "*");
        nodeProperties.prependIfNew(":displayExtension", "");
        nodeProperties.prependIfNew(":status", "browser");
        if (clientNodeProperties == null) {
            nodeProperties.add("jcr:created", "");
        }
        nodeProperties.addOrReplace("_charset_", "UTF-8");
        if (nodeProperties.size() > 0) {
            if (multiPart) {
                Iterator<NameValuePair> partList = new ArrayList();
                for (NameValuePair e : nodeProperties) {
                    if (e.getValue() == null) continue;
                    partList.add((NameValuePair)new StringPart(e.getName(), e.getValue(), "UTF-8"));
                }
                if (localFile != null) {
                    partList.add((NameValuePair)new FilePart(fieldName, localFile));
                    if (typeHint != null) {
                        partList.add((NameValuePair)new StringPart(fieldName + "@TypeHint", typeHint));
                    }
                }
                Part[] partArray = partList.toArray((Part[])new Part[partList.size()]);
                post.setRequestEntity((RequestEntity)new MultipartRequestEntity(partArray, post.getParams()));
            } else {
                post.getParams().setContentCharset("UTF-8");
                for (NameValuePair nameValuePair : nodeProperties) {
                    post.addParameter(nameValuePair.getName(), nameValuePair.getValue());
                }
            }
        }
        if (requestHeaders != null) {
            for (Map.Entry entry : requestHeaders.entrySet()) {
                post.addRequestHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        int expected = 302;
        int n = this.httpClient.executeMethod((HttpMethod)post);
        if (n != 302) {
            throw new HttpStatusCodeException(302, n, "POST", url, HttpTestBase.getResponseBodyAsStream((HttpMethodBase)post, 0));
        }
        String location = post.getResponseHeader("Location").getValue();
        post.releaseConnection();
        if (!location.startsWith("http://")) {
            String host = HttpTestBase.HTTP_BASE_URL;
            int idx = host.indexOf(47, 8);
            if (idx > 0) {
                host = host.substring(0, idx);
            }
            location = host + location;
        }
        return location;
    }

    public void uploadToFileNode(String url, File localFile, String fieldName, String typeHint) throws IOException {
        Part[] parts = new Part[typeHint == null ? 1 : 2];
        parts[0] = new FilePart(fieldName, localFile);
        if (typeHint != null) {
            parts[1] = new StringPart(fieldName + "@TypeHint", typeHint);
        }
        PostMethod post = new PostMethod(url);
        post.setFollowRedirects(false);
        post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
        int status = this.httpClient.executeMethod((HttpMethod)post);
        int expected = 200;
        if (status != 200) {
            throw new HttpStatusCodeException(200, status, "POST", HttpTestBase.getResponseBodyAsStream((HttpMethodBase)post, 0));
        }
    }

    public void uploadToFileNodes(String url, File[] localFiles, String[] fieldNames, String[] typeHints) throws IOException {
        ArrayList<Object> partsList = new ArrayList<Object>();
        for (int i = 0; i < localFiles.length; ++i) {
            FilePart filePart = new FilePart(fieldNames[i], localFiles[i]);
            partsList.add(filePart);
            if (typeHints == null) continue;
            StringPart typeHintPart = new StringPart(fieldNames[i] + "@TypeHint", typeHints[i]);
            partsList.add(typeHintPart);
        }
        Part[] parts = partsList.toArray(new Part[partsList.size()]);
        PostMethod post = new PostMethod(url);
        post.setFollowRedirects(false);
        post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
        int expected = 200;
        int status = this.httpClient.executeMethod((HttpMethod)post);
        if (status != 200) {
            throw new HttpStatusCodeException(200, status, "POST", HttpTestBase.getResponseBodyAsStream((HttpMethodBase)post, 0));
        }
    }

    public int post(String url, Map<String, String> properties) throws HttpException, IOException {
        PostMethod post = new PostMethod(url);
        post.getParams().setContentCharset("UTF-8");
        for (Map.Entry<String, String> e : properties.entrySet()) {
            post.addParameter(e.getKey(), e.getValue());
        }
        return this.httpClient.executeMethod((HttpMethod)post);
    }

    public int get(String url) throws HttpException, IOException {
        GetMethod get = new GetMethod(url);
        get.getParams().setContentCharset("UTF-8");
        return this.httpClient.executeMethod((HttpMethod)get);
    }
}

