/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

@Component(metatype=true, configurationFactory=true, label="Apache Sling Dynamic Include - Configuration", immediate=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={Configuration.class})
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="include-filter.config.enabled", boolValue={false}, label="Enabled", description="Check to enable the filter"), @Property(name="include-filter.config.path", value={"/content"}, label="Base path", description="This SDI configuration will work only for this path"), @Property(name="include-filter.config.resource-types", cardinality=0x7FFFFFFF, label="Resource types", description="Filter will replace components with selected resource types"), @Property(name="include-filter.config.include-type", value={"SSI"}, label="Include type", description="Type of generated include tags", options={@PropertyOption(name="SSI", value="Apache SSI"), @PropertyOption(name="ESI", value="ESI"), @PropertyOption(name="JSI", value="Javascript")}), @Property(name="include-filter.config.add_comment", boolValue={false}, label="Add comment", description="Add comment to included components"), @Property(name="include-filter.config.selector", value={"nocache"}, label="Filter selector", description="Selector used to mark included resources"), @Property(name="include-filter.config.ttl", label="Component TTL", description="\"Time to live\" cache header for rendered component (in seconds)"), @Property(name="include-filter.config.required_header", value={"Server-Agent=Communique-Dispatcher"}, label="Required header", description="SDI will work only for requests with given header"), @Property(name="include-filter.config.ignoreUrlParams", cardinality=0x7FFFFFFF, label="Ignore URL params", description="SDI will process the request even if it contains configured GET parameters"), @Property(name="include-filter.config.rewrite", boolValue={false}, label="Include path rewriting", description="Check to enable include path rewriting")})
public class Configuration {
    static final String PROPERTY_FILTER_PATH = "include-filter.config.path";
    static final String DEFAULT_FILTER_PATH = "/content";
    static final String PROPERTY_FILTER_ENABLED = "include-filter.config.enabled";
    static final boolean DEFAULT_FILTER_ENABLED = false;
    static final String PROPERTY_FILTER_RESOURCE_TYPES = "include-filter.config.resource-types";
    static final String PROPERTY_FILTER_SELECTOR = "include-filter.config.selector";
    static final String DEFAULT_FILTER_SELECTOR = "nocache";
    static final String PROPERTY_COMPONENT_TTL = "include-filter.config.ttl";
    static final String PROPERTY_INCLUDE_TYPE = "include-filter.config.include-type";
    static final String DEFAULT_INCLUDE_TYPE = "SSI";
    static final String PROPERTY_ADD_COMMENT = "include-filter.config.add_comment";
    static final boolean DEFAULT_ADD_COMMENT = false;
    static final String PROPERTY_REQUIRED_HEADER = "include-filter.config.required_header";
    static final String DEFAULT_REQUIRED_HEADER = "Server-Agent=Communique-Dispatcher";
    static final String PROPERTY_IGNORE_URL_PARAMS = "include-filter.config.ignoreUrlParams";
    static final String PROPERTY_REWRITE_PATH = "include-filter.config.rewrite";
    static final boolean DEFAULT_REWRITE_DISABLED = false;
    private boolean isEnabled;
    private String path;
    private String includeSelector;
    private int ttl;
    private List<String> resourceTypes;
    private boolean addComment;
    private String includeTypeName;
    private String requiredHeader;
    private List<String> ignoreUrlParams;
    private boolean rewritePath;

    @Activate
    public void activate(ComponentContext context, Map<String, ?> properties) {
        this.isEnabled = PropertiesUtil.toBoolean(properties.get(PROPERTY_FILTER_ENABLED), (boolean)false);
        this.path = PropertiesUtil.toString(properties.get(PROPERTY_FILTER_PATH), (String)DEFAULT_FILTER_PATH);
        String[] resourceTypeList = PropertiesUtil.toStringArray(properties.get(PROPERTY_FILTER_RESOURCE_TYPES), (String[])new String[0]);
        for (int i = 0; i < resourceTypeList.length; ++i) {
            String name;
            String[] s = resourceTypeList[i].split(";");
            resourceTypeList[i] = name = s[0].trim();
        }
        this.resourceTypes = Arrays.asList(resourceTypeList);
        this.includeSelector = PropertiesUtil.toString(properties.get(PROPERTY_FILTER_SELECTOR), (String)DEFAULT_FILTER_SELECTOR);
        this.ttl = PropertiesUtil.toInteger(properties.get(PROPERTY_COMPONENT_TTL), (int)-1);
        this.addComment = PropertiesUtil.toBoolean(properties.get(PROPERTY_ADD_COMMENT), (boolean)false);
        this.includeTypeName = PropertiesUtil.toString(properties.get(PROPERTY_INCLUDE_TYPE), (String)DEFAULT_INCLUDE_TYPE);
        this.requiredHeader = PropertiesUtil.toString(properties.get(PROPERTY_REQUIRED_HEADER), (String)DEFAULT_REQUIRED_HEADER);
        this.ignoreUrlParams = Arrays.asList(PropertiesUtil.toStringArray(properties.get(PROPERTY_IGNORE_URL_PARAMS), (String[])new String[0]));
        this.rewritePath = PropertiesUtil.toBoolean(properties.get(PROPERTY_REWRITE_PATH), (boolean)false);
    }

    public String getBasePath() {
        return this.path;
    }

    public boolean hasIncludeSelector(SlingHttpServletRequest request) {
        return ArrayUtils.contains((Object[])request.getRequestPathInfo().getSelectors(), (Object)this.includeSelector);
    }

    public String getIncludeSelector() {
        return this.includeSelector;
    }

    public boolean hasTtlSet() {
        return this.ttl >= 0;
    }

    public int getTtl() {
        return this.ttl;
    }

    public boolean isSupportedResourceType(String resourceType) {
        return StringUtils.isNotBlank((String)resourceType) && this.resourceTypes.contains(resourceType);
    }

    public boolean getAddComment() {
        return this.addComment;
    }

    public String getIncludeTypeName() {
        return this.includeTypeName;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getRequiredHeader() {
        return this.requiredHeader;
    }

    public List<String> getIgnoreUrlParams() {
        return this.ignoreUrlParams;
    }

    public boolean isRewritePath() {
        return this.rewritePath;
    }
}

