/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.util.Arrays;
import java.util.Optional;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.engine.impl.request.RequestData;
import org.jetbrains.annotations.NotNull;

public class IncludeNoContentTypeOverrideResponseWrapper
extends SlingHttpServletResponseWrapper {
    private final RequestData requestData;

    public IncludeNoContentTypeOverrideResponseWrapper(@NotNull RequestData requestData, @NotNull SlingHttpServletResponse wrappedResponse) {
        super(wrappedResponse);
        this.requestData = requestData;
    }

    public void setContentType(String type) {
        String contentTypeString = this.getContentType();
        if (contentTypeString != null) {
            if (type == null) {
                String message = this.getMessage(contentTypeString, "null");
                this.requestData.getRequestProgressTracker().log("ERROR: " + message);
                throw new ContentTypeChangeException(message);
            }
            Optional<String> currentMime = Arrays.stream(contentTypeString.split(";")).findFirst();
            Optional<String> setMime = Arrays.stream(type.split(";")).findFirst();
            if (currentMime.isPresent() && setMime.isPresent() && !currentMime.get().equals(setMime.get())) {
                String message = this.getMessage(contentTypeString, type);
                this.requestData.getRequestProgressTracker().log("ERROR: " + message);
                throw new ContentTypeChangeException(message);
            }
            this.getResponse().setContentType(type);
        }
    }

    private String getMessage(String currentContentType, String setContentType) {
        return String.format("Servlet %s tried to override the 'Content-Type' header from '%s' to '%s', however the %s forbids this via the %s configuration property.", this.requestData.getActiveServletName(), currentContentType, setContentType, "org.apache.sling.engine.impl.SlingMainServlet", "sling.includes.checkcontenttype");
    }

    private static class ContentTypeChangeException
    extends SlingException {
        protected ContentTypeChangeException(String text) {
            super(text);
        }
    }
}

