/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.Part;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.engine.impl.helper.NullResourceBundle;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.request.ContentData;
import org.apache.sling.engine.impl.request.DispatchingInfo;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.impl.request.SlingRequestDispatcher;
import org.osgi.service.useradmin.Authorization;

public class SlingHttpServletRequestImpl
extends HttpServletRequestWrapper
implements SlingHttpServletRequest {
    private static final List<String> FORWARD_ATTRIBUTES = Arrays.asList("javax.servlet.forward.context_path", "javax.servlet.forward.path_info", "javax.servlet.forward.query_string", "javax.servlet.forward.request_uri", "javax.servlet.forward.servlet_path");
    private static final List<String> INCLUDE_ATTRIBUTES = Arrays.asList("org.apache.sling.api.include.resource", "org.apache.sling.api.include.servlet", "org.apache.sling.api.include.request_path_info", "javax.servlet.include.context_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string", "javax.servlet.include.request_uri", "javax.servlet.include.servlet_path");
    private final RequestData requestData;
    private final String pathInfo;
    private String responseContentType;

    public SlingHttpServletRequestImpl(RequestData requestData, HttpServletRequest servletRequest) {
        super(servletRequest);
        this.requestData = requestData;
        String pathInfo = servletRequest.getServletPath();
        if (servletRequest.getPathInfo() != null) {
            pathInfo = pathInfo.concat(servletRequest.getPathInfo());
        }
        this.pathInfo = pathInfo;
    }

    public final RequestData getRequestData() {
        return this.requestData;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        return this.getRequestData().getSlingRequestProcessor().adaptTo((Object)this, type);
    }

    ParameterSupport getParameterSupport() {
        return this.getRequestData().getParameterSupport();
    }

    public Resource getResource() {
        ContentData cd = this.getRequestData().getContentData();
        return cd == null ? null : cd.getResource();
    }

    public ResourceResolver getResourceResolver() {
        return this.getRequestData().getResourceResolver();
    }

    public RequestProgressTracker getRequestProgressTracker() {
        return this.getRequestData().getRequestProgressTracker();
    }

    public RequestDispatcher getRequestDispatcher(Resource resource) {
        return this.getRequestDispatcher(resource, null);
    }

    public RequestDispatcher getRequestDispatcher(Resource resource, RequestDispatcherOptions options) {
        return resource != null ? new SlingRequestDispatcher(resource, options, this.requestData.protectHeadersOnInclude(), this.requestData.checkContentTypeOnInclude()) : null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.getRequestDispatcher(path, null);
    }

    public RequestDispatcher getRequestDispatcher(String path, RequestDispatcherOptions options) {
        return path != null ? new SlingRequestDispatcher(path, options, this.requestData.protectHeadersOnInclude(), this.requestData.checkContentTypeOnInclude()) : null;
    }

    public String getParameter(String name) {
        return this.getParameterSupport().getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.getParameterSupport().getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return this.getParameterSupport().getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.getParameterSupport().getParameterValues(name);
    }

    public RequestParameter getRequestParameter(String name) {
        return this.getParameterSupport().getRequestParameter(name);
    }

    public RequestParameter[] getRequestParameters(String name) {
        return this.getParameterSupport().getRequestParameters(name);
    }

    public RequestParameterMap getRequestParameterMap() {
        return this.getParameterSupport().getRequestParameterMap();
    }

    public List<RequestParameter> getRequestParameterList() {
        return this.getParameterSupport().getRequestParameterList();
    }

    public Cookie getCookie(String name) {
        Cookie[] cookies = this.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(name)) continue;
                return cookies[i];
            }
        }
        return null;
    }

    public RequestPathInfo getRequestPathInfo() {
        ContentData cd = this.getRequestData().getContentData();
        return cd == null ? null : cd.getRequestPathInfo();
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getResourceBundle(null, locale);
    }

    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        if (locale == null) {
            locale = this.getLocale();
        }
        return new NullResourceBundle(locale);
    }

    public String getResponseContentType() {
        String ext;
        if (this.responseContentType == null && (ext = this.getRequestPathInfo().getExtension()) != null) {
            this.responseContentType = this.requestData.getSlingRequestProcessor().getMimeType("dummy.".concat(ext));
        }
        return this.responseContentType;
    }

    public Enumeration<String> getResponseContentTypes() {
        String singleType = this.getResponseContentType();
        if (singleType != null) {
            return Collections.enumeration(Collections.singleton(singleType));
        }
        return Collections.emptyEnumeration();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.getRequestData().getInputStream();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        return this.getRequestData().getReader();
    }

    public Principal getUserPrincipal() {
        if (this.getRemoteUser() == null) {
            return null;
        }
        Principal principal = (Principal)this.getResourceResolver().adaptTo(Principal.class);
        if (principal != null) {
            return principal;
        }
        String remoteUser = this.getRemoteUser();
        return remoteUser != null ? new UserPrincipal(remoteUser) : null;
    }

    public boolean isUserInRole(String role) {
        Object authorization = this.getAttribute("org.osgi.service.useradmin.authorization");
        return authorization instanceof Authorization ? ((Authorization)authorization).hasRole(role) : false;
    }

    public String getServletPath() {
        return "";
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public Part getPart(String name) {
        return (Part)this.getParameterSupport().getPart(name);
    }

    public Collection<Part> getParts() {
        return this.getParameterSupport().getParts();
    }

    public Object getAttribute(String name) {
        DispatchingInfo dispatchingInfo = this.requestData.getDispatchingInfo();
        if (dispatchingInfo != null && dispatchingInfo.getType() == DispatcherType.INCLUDE) {
            if ("org.apache.sling.api.include.resource".equals(name)) {
                return dispatchingInfo.getRequestContent();
            }
            if ("org.apache.sling.api.include.servlet".equals(name)) {
                return dispatchingInfo.getRequestServlet();
            }
            if ("org.apache.sling.api.include.request_path_info".equals(name)) {
                return dispatchingInfo.getRequestPathInfo();
            }
            if ("javax.servlet.include.context_path".equals(name)) {
                return dispatchingInfo.getContextPath();
            }
            if ("javax.servlet.include.path_info".equals(name)) {
                return dispatchingInfo.getPathInfo();
            }
            if ("javax.servlet.include.query_string".equals(name)) {
                return dispatchingInfo.getQueryString();
            }
            if ("javax.servlet.include.request_uri".equals(name)) {
                return dispatchingInfo.getRequestUri();
            }
            if ("javax.servlet.include.servlet_path".equals(name)) {
                return dispatchingInfo.getServletPath();
            }
            if (FORWARD_ATTRIBUTES.contains(name)) {
                return super.getAttribute(name);
            }
        }
        if (INCLUDE_ATTRIBUTES.contains(name) || FORWARD_ATTRIBUTES.contains(name)) {
            return null;
        }
        return super.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        DispatchingInfo dispatchingInfo = this.requestData.getDispatchingInfo();
        if (dispatchingInfo != null && dispatchingInfo.getType() == DispatcherType.INCLUDE) {
            HashSet allNames = new HashSet(Collections.list(super.getAttributeNames()));
            allNames.addAll(INCLUDE_ATTRIBUTES);
            return Collections.enumeration(allNames);
        }
        return super.getAttributeNames();
    }

    private static class UserPrincipal
    implements Principal,
    Serializable {
        private final String name;

        public UserPrincipal(String name) throws IllegalArgumentException {
            if (name == null) {
                throw new IllegalArgumentException("name can not be null");
            }
            this.name = name;
        }

        @Override
        public String toString() {
            return "UserPrincipal: " + this.name;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UserPrincipal) {
                UserPrincipal other = (UserPrincipal)obj;
                return this.name.equals(other.name);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

