/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RecursionTooDeepException;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.request.TooManyCallsException;
import org.apache.sling.api.request.builder.Builders;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.engine.impl.SlingHttpServletRequestImpl;
import org.apache.sling.engine.impl.SlingHttpServletResponseImpl;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.adapter.SlingServletRequestAdapter;
import org.apache.sling.engine.impl.adapter.SlingServletResponseAdapter;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.request.ContentData;
import org.apache.sling.engine.impl.request.DispatchingInfo;
import org.apache.sling.engine.impl.request.SlingRequestPathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestData {
    private static final Logger log = LoggerFactory.getLogger(RequestData.class);
    public static final String REQUEST_RESOURCE_PATH_ATTR = "$$sling.request.resource$$";
    private static String REQUEST_MAX_CALL_OVERRIDE = "sling.max.calls";
    private final SlingRequestProcessorImpl slingRequestProcessor;
    private final long startTimestamp = System.currentTimeMillis();
    private final HttpServletRequest servletRequest;
    private final HttpServletResponse servletResponse;
    private final SlingHttpServletRequest slingRequest;
    private final SlingHttpServletResponse slingResponse;
    private final boolean protectHeadersOnInclude;
    private final boolean checkContentTypeOnInclude;
    private ParameterSupport parameterSupport;
    private ResourceResolver resourceResolver;
    private final RequestProgressTracker requestProgressTracker;
    private ContentData currentContentData;
    private int servletCallCounter;
    private String activeServletName;
    private int recursionDepth;
    private int peakRecusionDepth;
    private DispatchingInfo dispatchingInfo;
    private static final Set<Character> SKIPPED_TRAVERSAL_CHARS = new HashSet<Character>();

    public RequestData(SlingRequestProcessorImpl slingRequestProcessor, HttpServletRequest request, HttpServletResponse response, boolean protectHeadersOnInclude, boolean checkContentTypeOnInclude) {
        this.slingRequestProcessor = slingRequestProcessor;
        this.servletRequest = request;
        this.servletResponse = response;
        this.protectHeadersOnInclude = protectHeadersOnInclude;
        this.checkContentTypeOnInclude = checkContentTypeOnInclude;
        this.slingRequest = new SlingHttpServletRequestImpl(this, this.servletRequest);
        this.slingResponse = new SlingHttpServletResponseImpl(this, this.servletResponse);
        if (request instanceof SlingHttpServletRequest) {
            this.requestProgressTracker = ((SlingHttpServletRequest)request).getRequestProgressTracker();
        } else {
            Object o = request.getAttribute(RequestProgressTracker.class.getName());
            if (o instanceof RequestProgressTracker) {
                this.requestProgressTracker = (RequestProgressTracker)o;
            } else {
                log.warn("RequestProgressTracker not found in request attributes");
                this.requestProgressTracker = Builders.newRequestProgressTracker();
                this.requestProgressTracker.log("Method={0}, PathInfo={1}", new Object[]{request.getMethod(), request.getPathInfo()});
            }
        }
    }

    public Resource initResource(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        this.requestProgressTracker.startTimer("ResourceResolution");
        SlingHttpServletRequest request = this.getSlingRequest();
        StringBuffer requestURL = this.servletRequest.getRequestURL();
        String path = request.getPathInfo();
        if (requestURL.indexOf(";") > -1 && !path.contains(";")) {
            try {
                URL rUrl = new URL(requestURL.toString());
                String prefix = request.getContextPath().concat(request.getServletPath());
                path = rUrl.getPath().substring(prefix.length());
            }
            catch (MalformedURLException rUrl) {
                // empty catch block
            }
        }
        Resource resource = resourceResolver.resolve((HttpServletRequest)request, path);
        if (request.getAttribute(REQUEST_RESOURCE_PATH_ATTR) == null) {
            request.setAttribute(REQUEST_RESOURCE_PATH_ATTR, (Object)resource.getPath());
        }
        this.requestProgressTracker.logTimer("ResourceResolution", "URI={0} resolves to Resource={1}", new Object[]{this.getServletRequest().getRequestURI(), resource});
        return resource;
    }

    public void initServlet(Resource resource, ServletResolver sr) {
        SlingRequestPathInfo requestPathInfo = new SlingRequestPathInfo(resource);
        ContentData contentData = this.setContent(resource, requestPathInfo);
        this.requestProgressTracker.log("Resource Path Info: {0}", new Object[]{requestPathInfo});
        this.requestProgressTracker.startTimer("ServletResolution");
        Servlet servlet = sr.resolveServlet(this.slingRequest);
        this.requestProgressTracker.logTimer("ServletResolution", "URI={0} handled by Servlet={1}", new Object[]{this.getServletRequest().getRequestURI(), servlet == null ? "-none-" : RequestUtil.getServletName((Servlet)servlet)});
        contentData.setServlet(servlet);
    }

    public SlingRequestProcessorImpl getSlingRequestProcessor() {
        return this.slingRequestProcessor;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public SlingHttpServletRequest getSlingRequest() {
        return this.slingRequest;
    }

    public SlingHttpServletResponse getSlingResponse() {
        return this.slingResponse;
    }

    public DispatchingInfo getDispatchingInfo() {
        return this.dispatchingInfo;
    }

    public void setDispatchingInfo(DispatchingInfo dispatchingInfo) {
        this.dispatchingInfo = dispatchingInfo;
    }

    public static SlingHttpServletRequest unwrap(ServletRequest request) {
        if (request instanceof SlingHttpServletRequest) {
            return (SlingHttpServletRequest)request;
        }
        while (request instanceof ServletRequestWrapper) {
            if (!((request = ((ServletRequestWrapper)request).getRequest()) instanceof SlingHttpServletRequest)) continue;
            return (SlingHttpServletRequest)request;
        }
        throw new IllegalArgumentException("ServletRequest not wrapping SlingHttpServletRequest");
    }

    public static SlingHttpServletRequestImpl unwrap(SlingHttpServletRequest request) {
        while (request instanceof SlingHttpServletRequestWrapper) {
            request = ((SlingHttpServletRequestWrapper)request).getSlingRequest();
        }
        if (request instanceof SlingHttpServletRequestImpl) {
            return (SlingHttpServletRequestImpl)request;
        }
        throw new IllegalArgumentException("SlingHttpServletRequest not of correct type");
    }

    public static SlingHttpServletResponse unwrap(ServletResponse response) {
        if (response instanceof SlingHttpServletResponse) {
            return (SlingHttpServletResponse)response;
        }
        while (response instanceof ServletResponseWrapper) {
            if (!((response = ((ServletResponseWrapper)response).getResponse()) instanceof SlingHttpServletResponse)) continue;
            return (SlingHttpServletResponse)response;
        }
        throw new IllegalArgumentException("ServletResponse not wrapping SlingHttpServletResponse");
    }

    public static SlingHttpServletResponseImpl unwrap(SlingHttpServletResponse response) {
        while (response instanceof SlingHttpServletResponseWrapper) {
            response = ((SlingHttpServletResponseWrapper)response).getSlingResponse();
        }
        if (response instanceof SlingHttpServletResponseImpl) {
            return (SlingHttpServletResponseImpl)response;
        }
        throw new IllegalArgumentException("SlingHttpServletResponse not of correct type");
    }

    public static RequestData getRequestData(ServletRequest request) {
        return RequestData.unwrap(RequestData.unwrap(request)).getRequestData();
    }

    public static RequestData getRequestData(SlingHttpServletRequest request) {
        return RequestData.unwrap(request).getRequestData();
    }

    public static SlingHttpServletRequest toSlingHttpServletRequest(ServletRequest request) {
        SlingHttpServletRequest cRequest = RequestData.unwrap(request);
        RequestData.unwrap(cRequest);
        if (cRequest == request) {
            return cRequest;
        }
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HTTP request");
        }
        return new SlingServletRequestAdapter(cRequest, (HttpServletRequest)request);
    }

    public static SlingHttpServletResponse toSlingHttpServletResponse(ServletResponse response) {
        SlingHttpServletResponse cResponse = RequestData.unwrap(response);
        if (cResponse == response) {
            return cResponse;
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new IllegalArgumentException("Response is not an HTTP response");
        }
        return new SlingServletResponseAdapter(cResponse, (HttpServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void service(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        if (!RequestData.isValidRequest(request.getRequestPathInfo().getResourcePath(), request.getRequestPathInfo().getSelectors())) {
            response.sendError(400, "Malformed request syntax");
            return;
        }
        RequestData requestData = RequestData.getRequestData(request);
        Servlet servlet = requestData.getContentData().getServlet();
        if (servlet == null) {
            response.sendError(404, "No Servlet to handle request");
        } else {
            String name = RequestUtil.getServletName((Servlet)servlet);
            if (requestData.hasServletMaxCallCount((ServletRequest)request)) {
                throw new TooManyCallsException(name);
            }
            Object oldValue = request.getAttribute("sling.core.current.servletName");
            request.setAttribute("sling.core.current.servletName", (Object)name);
            String timerName = name + "#" + requestData.servletCallCounter;
            ++requestData.servletCallCounter;
            requestData.getRequestProgressTracker().startTimer(timerName);
            try {
                String callerServlet = requestData.setActiveServletName(name);
                servlet.service((ServletRequest)request, (ServletResponse)response);
                requestData.setActiveServletName(callerServlet);
            }
            finally {
                request.setAttribute("sling.core.current.servletName", oldValue);
                requestData.getRequestProgressTracker().logTimer(timerName);
            }
        }
    }

    static boolean isValidRequest(String resourcePath, String ... selectors) {
        for (String selector : selectors) {
            if (!selector.trim().isEmpty()) continue;
            return false;
        }
        return resourcePath == null || !RequestData.traversesParentPath(resourcePath);
    }

    public ContentData setContent(Resource resource, RequestPathInfo requestPathInfo) {
        if (this.recursionDepth >= this.slingRequestProcessor.getMaxIncludeCounter()) {
            throw new RecursionTooDeepException(requestPathInfo.getResourcePath());
        }
        ++this.recursionDepth;
        if (this.recursionDepth > this.peakRecusionDepth) {
            this.peakRecusionDepth = this.recursionDepth;
        }
        this.currentContentData = new ContentData(resource, requestPathInfo);
        return this.currentContentData;
    }

    public void resetContent(ContentData data) {
        --this.recursionDepth;
        this.currentContentData = data;
    }

    public ContentData getContentData() {
        return this.currentContentData;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public RequestProgressTracker getRequestProgressTracker() {
        return this.requestProgressTracker;
    }

    public int getPeakRecusionDepth() {
        return this.peakRecusionDepth;
    }

    public int getServletCallCount() {
        return this.servletCallCounter;
    }

    public boolean protectHeadersOnInclude() {
        return this.protectHeadersOnInclude;
    }

    public boolean checkContentTypeOnInclude() {
        return this.checkContentTypeOnInclude;
    }

    private boolean hasServletMaxCallCount(ServletRequest request) {
        log.debug("Servlet call counter : {}", (Object)this.getServletCallCount());
        int maxCallCounter = this.slingRequestProcessor.getMaxCallCounter();
        Object reqMaxOverride = request.getAttribute(REQUEST_MAX_CALL_OVERRIDE);
        if (reqMaxOverride instanceof Number) {
            maxCallCounter = ((Number)reqMaxOverride).intValue();
        }
        return maxCallCounter >= 0 && this.getServletCallCount() >= maxCallCounter;
    }

    public long getElapsedTimeMsec() {
        return System.currentTimeMillis() - this.startTimestamp;
    }

    public String setActiveServletName(String servletName) {
        String old = this.activeServletName;
        this.activeServletName = servletName;
        return old;
    }

    public String getActiveServletName() {
        return this.activeServletName;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.parameterSupport != null && this.parameterSupport.requestDataUsed()) {
            throw new IllegalStateException("Request Data has already been read");
        }
        return this.getServletRequest().getInputStream();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (this.parameterSupport != null && this.parameterSupport.requestDataUsed()) {
            throw new IllegalStateException("Request Data has already been read");
        }
        return this.getServletRequest().getReader();
    }

    public ParameterSupport getParameterSupport() {
        if (this.parameterSupport == null) {
            this.parameterSupport = ParameterSupport.getInstance(this.getServletRequest());
        }
        return this.parameterSupport;
    }

    private static boolean traversesParentPath(String path) {
        for (int index = 0; index < path.length(); ++index) {
            int charCount = 0;
            int dotCount = 0;
            while (index < path.length() && path.charAt(index) != '/') {
                char c = path.charAt(index);
                if (!SKIPPED_TRAVERSAL_CHARS.contains(Character.valueOf(c))) {
                    if (c == '.') {
                        ++dotCount;
                    }
                    ++charCount;
                }
                ++index;
            }
            if (charCount <= true || dotCount != charCount) continue;
            return true;
        }
        return false;
    }

    static {
        SKIPPED_TRAVERSAL_CHARS.add(Character.valueOf('['));
        SKIPPED_TRAVERSAL_CHARS.add(Character.valueOf('}'));
    }
}

