/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.helper;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.sling.engine.impl.SlingMainServlet;
import org.apache.sling.engine.impl.helper.ExternalServletContextWrapper;
import org.apache.sling.engine.impl.request.SlingRequestDispatcher;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingServletContext
implements ServletContext {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SlingMainServlet slingMainServlet;
    private AtomicReference<ServiceRegistration<ServletContext>> registration = new AtomicReference();

    public SlingServletContext(BundleContext bundleContext, SlingMainServlet slingMainServlet) {
        this.slingMainServlet = slingMainServlet;
    }

    public void register(BundleContext bundleContext) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Apache Sling ServletContext");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("name", "org.apache.sling");
        this.registration.set((ServiceRegistration<ServletContext>)bundleContext.registerService(ServletContext.class, (Object)this, props));
    }

    public void dispose() {
        ServiceRegistration localRegistration = this.registration.getAndSet(null);
        if (localRegistration != null) {
            localRegistration.unregister();
        }
    }

    public String getServletContextName() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getServletContextName();
        }
        return null;
    }

    public String getContextPath() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getContextPath();
        }
        return null;
    }

    public String getInitParameter(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getInitParameter(name);
        }
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getInitParameterNames();
        }
        return null;
    }

    public Object getAttribute(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getAttribute(name);
        }
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getAttributeNames();
        }
        return Collections.enumeration(Collections.emptyList());
    }

    public void removeAttribute(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            delegatee.removeAttribute(name);
        }
    }

    public void setAttribute(String name, Object object) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            delegatee.setAttribute(name, object);
        }
    }

    public String getServerInfo() {
        return this.slingMainServlet.getServerInfo();
    }

    public int getMajorVersion() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getMajorVersion();
        }
        return 3;
    }

    public int getMinorVersion() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getMinorVersion();
        }
        return 0;
    }

    public String getMimeType(String file) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getMimeType(file);
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            this.log.error("getRequestDispatcher: No path, cannot create request dispatcher");
            return null;
        }
        return new SlingRequestDispatcher(path, null);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getNamedDispatcher(name);
        }
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getResource(path);
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getResourceAsStream(path);
        }
        return null;
    }

    public Set<String> getResourcePaths(String parentPath) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getResourcePaths(parentPath);
        }
        return null;
    }

    public String getRealPath(String path) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getRealPath(path);
        }
        return null;
    }

    public void log(String message, Throwable throwable) {
        this.log.error(message, throwable);
    }

    public void log(String message) {
        this.log.info(message);
    }

    @Deprecated
    public void log(Exception exception, String message) {
        this.log(message, exception);
    }

    public ServletContext getContext(String uripath) {
        ServletContext otherContext;
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null && (otherContext = delegatee.getContext(uripath)) != null && otherContext != delegatee) {
            return this.wrapServletContext(otherContext);
        }
        return null;
    }

    @Deprecated
    public Servlet getServlet(String name) {
        return null;
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        return Collections.enumeration(Collections.emptyList());
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return Collections.enumeration(Collections.emptyList());
    }

    public int getEffectiveMajorVersion() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getEffectiveMajorVersion();
        }
        return 3;
    }

    public int getEffectiveMinorVersion() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getEffectiveMinorVersion();
        }
        return 0;
    }

    public boolean setInitParameter(String name, String value) {
        throw new IllegalStateException();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.getServletContext().getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new IllegalStateException();
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.getServletContext().getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.getServletContext().getEffectiveSessionTrackingModes();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.getServletContext().getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        throw new SecurityException();
    }

    public void declareRoles(String ... roleNames) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new IllegalStateException();
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) {
        throw new IllegalStateException();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        throw new IllegalStateException();
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        throw new IllegalStateException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new IllegalStateException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new IllegalStateException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new IllegalStateException();
    }

    public <T extends Filter> T createFilter(Class<T> clazz) {
        throw new IllegalStateException();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        throw new IllegalStateException();
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        throw new IllegalStateException();
    }

    public void addListener(String className) {
        throw new IllegalStateException();
    }

    public <T extends EventListener> void addListener(T t) {
        throw new IllegalStateException();
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new IllegalStateException();
    }

    public <T extends EventListener> T createListener(Class<T> clazz) {
        throw new IllegalStateException();
    }

    protected ServletContext getServletContext() {
        return this.slingMainServlet.getServletContext();
    }

    protected ServletContext wrapServletContext(ServletContext context) {
        return new ExternalServletContextWrapper(context);
    }

    public String getVirtualServerName() {
        return this.getServletContext().getVirtualServerName();
    }
}

