/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterPredicate {
    private static final Logger LOG = LoggerFactory.getLogger(FilterPredicate.class);
    Collection<String> methods;
    Collection<String> selectors;
    Collection<String> extensions;
    Collection<String> resourceTypes;
    Pattern pathRegex;
    Pattern resourcePathRegex;
    Pattern requestPathRegex;
    Pattern suffixRegex;

    public FilterPredicate(ServiceReference<Filter> reference) {
        this.selectors = this.asCollection(reference, "sling.filter.selectors");
        this.extensions = this.asCollection(reference, "sling.filter.extensions");
        this.resourceTypes = this.asCollection(reference, "sling.filter.resourceTypes");
        this.methods = this.asCollection(reference, "sling.filter.methods");
        this.pathRegex = this.asPattern(reference, "sling.filter.pattern");
        this.resourcePathRegex = this.asPattern(reference, "sling.filter.resource.pattern");
        this.requestPathRegex = this.asPattern(reference, "sling.filter.request.pattern");
        this.suffixRegex = this.asPattern(reference, "sling.filter.suffix.pattern");
    }

    private Collection<String> asCollection(ServiceReference<Filter> reference, String propertyName) {
        String[] value = PropertiesUtil.toStringArray((Object)reference.getProperty(propertyName));
        return value != null && value.length > 0 ? Arrays.asList(value) : null;
    }

    private Pattern asPattern(ServiceReference<Filter> reference, String propertyName) {
        String pattern = PropertiesUtil.toString((Object)reference.getProperty(propertyName), null);
        return pattern != null && pattern.length() > 0 ? Pattern.compile(pattern) : null;
    }

    private boolean anyElementMatches(Collection<String> allowed, String ... actual) {
        return allowed == null || !Collections.disjoint(allowed, Arrays.asList(actual));
    }

    private boolean anyResourceTypeMatches(Collection<String> resourceTypes, SlingHttpServletRequest request) {
        if (resourceTypes == null) {
            return true;
        }
        Resource resource = request.getResource();
        for (String resourceType : resourceTypes) {
            if (!resource.isResourceType(resourceType)) continue;
            return true;
        }
        return false;
    }

    private boolean patternMatches(Pattern pattern, String candidate) {
        return pattern == null || candidate == null || pattern.matcher(candidate).matches();
    }

    boolean test(SlingHttpServletRequest req) {
        LOG.debug("starting filter test against {} request", (Object)req);
        RequestPathInfo requestPathInfo = req.getRequestPathInfo();
        String path = requestPathInfo.getResourcePath();
        String uri = req.getPathInfo();
        boolean select = this.anyElementMatches(this.methods, req.getMethod()) && this.anyElementMatches(this.selectors, requestPathInfo.getSelectors()) && this.anyElementMatches(this.extensions, requestPathInfo.getExtension()) && this.anyResourceTypeMatches(this.resourceTypes, req) && (this.patternMatches(this.pathRegex, path == null || path.isEmpty() ? "/" : path) || this.patternMatches(this.pathRegex, uri == null || uri.isEmpty() ? "/" : uri)) && this.patternMatches(this.requestPathRegex, uri == null || uri.isEmpty() ? "/" : uri) && this.patternMatches(this.resourcePathRegex, path == null || path.isEmpty() ? "/" : path) && this.patternMatches(this.suffixRegex, requestPathInfo.getSuffix());
        LOG.debug("selection of {} returned {}", (Object)this, (Object)select);
        return select;
    }

    public String toString() {
        return "FilterPredicate{methods='" + this.methods + '\'' + ", pathRegex=" + this.pathRegex + ", requestPathRegex=" + this.requestPathRegex + ", resourcePathRegex=" + this.resourcePathRegex + ", suffixRegex=" + this.suffixRegex + ", selectors='" + this.selectors + '\'' + ", extensions='" + this.extensions + '\'' + ", resourceTypes='" + this.resourceTypes + '\'' + '}';
    }
}

