/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.contentloader.ContentReader;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ContentReaderWhiteboard.class}, property={"service.vendor=The Apache Software Foundation"})
public class ContentReaderWhiteboard {
    private Map<String, ContentReader> readersByExtension = new LinkedHashMap<String, ContentReader>();
    private Map<String, ContentReader> readersByType = new LinkedHashMap<String, ContentReader>();

    public Map<String, ContentReader> getReadersByExtension() {
        return this.readersByExtension;
    }

    public Map<String, ContentReader> getReadersByType() {
        return this.readersByType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="contentReader", service=ContentReader.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindContentReader(ContentReader operation, Map<String, Object> properties) {
        Map<String, ContentReader> map;
        String[] extensions = PropertiesUtil.toStringArray((Object)properties.get("extensions"));
        String[] types = PropertiesUtil.toStringArray((Object)properties.get("contentTypes"));
        if (extensions != null) {
            map = this.readersByExtension;
            synchronized (map) {
                for (String extension : extensions) {
                    this.readersByExtension.put(extension, operation);
                }
            }
        }
        if (types != null) {
            map = this.readersByType;
            synchronized (map) {
                for (String type : types) {
                    this.readersByType.put(type, operation);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindContentReader(ContentReader operation, Map<String, Object> properties) {
        Map<String, ContentReader> map;
        String[] extensions = PropertiesUtil.toStringArray((Object)properties.get("extensions"));
        String[] types = PropertiesUtil.toStringArray((Object)properties.get("contentTypes"));
        if (this.readersByExtension != null && extensions != null) {
            map = this.readersByExtension;
            synchronized (map) {
                for (String extension : extensions) {
                    this.readersByExtension.remove(extension);
                }
            }
        }
        if (types != null) {
            map = this.readersByType;
            synchronized (map) {
                for (String type : types) {
                    this.readersByType.remove(type);
                }
            }
        }
    }
}

