/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionManager;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.contentloader.ContentCreator;
import org.apache.sling.jcr.contentloader.ContentImportListener;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.jcr.contentloader.ContentReader;
import org.apache.sling.jcr.contentloader.ContentTypeUtil;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.apache.sling.jcr.contentloader.internal.BaseImportLoader;
import org.apache.sling.jcr.contentloader.internal.ContentHelper;
import org.apache.sling.jcr.contentloader.internal.ContentReaderWhiteboard;
import org.apache.sling.jcr.contentloader.internal.DefaultContentCreator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ContentImporter.class}, property={"service.description=Apache Sling JCR Content Import Service", "service.vendor=The Apache Software Foundation"})
public class DefaultContentImporter
extends BaseImportLoader
implements ContentHelper,
ContentImporter {
    @Reference
    private MimeTypeService mimeTypeService;
    private final Logger logger = LoggerFactory.getLogger(DefaultContentImporter.class);

    @Reference(name="contentReaderWhiteboard", cardinality=ReferenceCardinality.MANDATORY, service=ContentReaderWhiteboard.class)
    protected void bindContentReaderWhiteboard(ContentReaderWhiteboard service) {
        this.contentReaderWhiteboard = service;
    }

    protected void unbindContentReaderWhiteboard(ContentReaderWhiteboard service) {
        if (this.contentReaderWhiteboard == service) {
            this.contentReaderWhiteboard = null;
        }
    }

    @Override
    public void importContent(Node parent, String filename, InputStream contentStream, ImportOptions importOptions, ContentImportListener importListener) throws RepositoryException, IOException {
        if (filename.endsWith(".jcr.xml")) {
            this.importJcrXml(parent, filename, contentStream, importOptions, importListener);
            return;
        }
        DefaultContentCreator contentCreator = new DefaultContentCreator(this);
        String readerExtension = this.getContentReaderExtension(filename);
        String name = this.toPlainName(filename, readerExtension);
        ContentReader contentReader = this.getContentReader(filename, importOptions);
        this.importContent(contentCreator, contentReader, parent, name, contentStream, importOptions, importListener);
    }

    @Override
    public void importContent(Node parent, String name, String contentType, InputStream contentStream, ImportOptions importOptions, ContentImportListener importListener) throws RepositoryException, IOException {
        if ("application/x-jcr+xml".equalsIgnoreCase(contentType)) {
            this.importJcrXml(parent, name, contentStream, importOptions, importListener);
            return;
        }
        DefaultContentCreator contentCreator = new DefaultContentCreator(this);
        String extension = ContentTypeUtil.getDefaultExtension(contentType);
        ContentReader contentReader = this.getContentReader(extension, importOptions);
        this.importContent(contentCreator, contentReader, parent, name, contentStream, importOptions, importListener);
    }

    private void importContent(DefaultContentCreator contentCreator, ContentReader contentReader, Node parent, String name, InputStream contentStream, ImportOptions importOptions, ContentImportListener importListener) throws RepositoryException, IOException {
        ArrayList<String> createdPaths = new ArrayList<String>();
        contentCreator.init(importOptions, this.getContentReaders(), createdPaths, importListener);
        contentCreator.prepareParsing(parent, name);
        contentReader.parse(contentStream, (ContentCreator)contentCreator);
        Session session = parent.getSession();
        session.save();
        for (Node versionable : contentCreator.getVersionables()) {
            VersionManager versionManager = versionable.getSession().getWorkspace().getVersionManager();
            versionManager.checkin(versionable.getPath());
            if (importListener == null) continue;
            importListener.onCheckin(versionable.getPath());
        }
    }

    private void importJcrXml(Node parent, String name, InputStream contentStream, ImportOptions importOptions, ContentImportListener importListener) throws IOException, RepositoryException {
        this.logger.debug("import JCR XML: '{}'", (Object)name);
        boolean replace = importOptions == null ? false : importOptions.isOverwrite();
        Node node = this.importJcrXml(parent, name, contentStream, replace);
        if (node != null && importListener != null) {
            importListener.onCreate(node.getPath());
        }
    }

    @Override
    public String getMimeType(String name) {
        MimeTypeService mts = this.mimeTypeService;
        return mts != null ? mts.getMimeType(name) : null;
    }
}

