/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.contentloader.internal.BundleContentLoader;
import org.apache.sling.jcr.contentloader.internal.BundleContentLoaderConfiguration;
import org.apache.sling.jcr.contentloader.internal.BundleHelper;
import org.apache.sling.jcr.contentloader.internal.ContentReaderWhiteboard;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={}, property={"service.vendor=The Apache Software Foundation", "service.description=Apache Sling Content Loader Implementation"}, configurationPolicy=ConfigurationPolicy.OPTIONAL)
@Designate(ocd=BundleContentLoaderConfiguration.class, factory=false)
public class BundleContentLoaderListener
implements SynchronousBundleListener,
BundleHelper {
    public static final String PROPERTY_CONTENT_LOADED = "content-loaded";
    public static final String PROPERTY_CONTENT_LOADED_AT = "content-load-time";
    private static final String PROPERTY_CONTENT_LOADED_BY = "content-loaded-by";
    private static final String PROPERTY_CONTENT_UNLOADED_AT = "content-unload-time";
    private static final String PROPERTY_CONTENT_UNLOADED_BY = "content-unloaded-by";
    public static final String PROPERTY_UNINSTALL_PATHS = "uninstall-paths";
    public static final String BUNDLE_CONTENT_NODE = "/var/sling/bundle-content";
    final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SlingRepository repository;
    @Reference
    private MimeTypeService mimeTypeService;
    @Reference
    private ContentReaderWhiteboard contentReaderWhiteboard;
    private BundleContentLoader bundleContentLoader;
    private String slingId;
    private final Set<String> updatedBundles = new HashSet<String>();
    @Reference
    protected SlingSettingsService settingsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void bundleChanged(BundleEvent event) {
        if (this.bundleContentLoader == null) {
            return;
        }
        Session session = null;
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 32: {
                try {
                    session = this.getSession();
                    boolean isUpdate = this.updatedBundles.remove(bundle.getSymbolicName());
                    this.bundleContentLoader.registerBundle(session, bundle, isUpdate);
                    break;
                }
                catch (Exception t) {
                    this.log.error("bundleChanged: Problem loading initial content of bundle " + bundle.getSymbolicName() + " (" + bundle.getBundleId() + ")", (Throwable)t);
                    break;
                }
                finally {
                    this.ungetSession(session);
                }
            }
            case 8: {
                this.updatedBundles.add(bundle.getSymbolicName());
                break;
            }
            case 16: {
                try {
                    session = this.getSession();
                    this.bundleContentLoader.unregisterBundle(session, bundle);
                    break;
                }
                catch (Exception t) {
                    this.log.error("bundleChanged: Problem unloading initial content of bundle " + bundle.getSymbolicName() + " (" + bundle.getBundleId() + ")", (Throwable)t);
                    break;
                }
                finally {
                    this.ungetSession(session);
                }
            }
        }
    }

    @Override
    public String getMimeType(String name) {
        MimeTypeService mts = this.mimeTypeService;
        return mts != null ? mts.getMimeType(name) : null;
    }

    @Override
    public void createRepositoryPath(Session writerSession, String repositoryPath) throws RepositoryException {
        if (!writerSession.itemExists(repositoryPath)) {
            Node node = writerSession.getRootNode();
            String path = repositoryPath.substring(1);
            int pos = path.lastIndexOf(47);
            if (pos != -1) {
                StringTokenizer st = new StringTokenizer(path.substring(0, pos), "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!node.hasNode(token)) {
                        node.addNode(token, "sling:Folder");
                        writerSession.save();
                    }
                    node = node.getNode(token);
                }
                path = path.substring(pos + 1);
            }
            if (!node.hasNode(path)) {
                node.addNode(path, "sling:Folder");
                writerSession.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected synchronized void activate(BundleContext bundleContext, BundleContentLoaderConfiguration configuration) {
        this.slingId = this.settingsService.getSlingId();
        this.bundleContentLoader = new BundleContentLoader(this, this.contentReaderWhiteboard, configuration);
        bundleContext.addBundleListener((BundleListener)this);
        Session session = null;
        try {
            Bundle[] bundles;
            session = this.getSession();
            this.createRepositoryPath(session, BUNDLE_CONTENT_NODE);
            this.log.debug("Activated - attempting to load content from all bundles which are neither INSTALLED nor UNINSTALLED");
            int ignored = 0;
            for (Bundle bundle : bundles = bundleContext.getBundles()) {
                if ((bundle.getState() & 3) == 0) {
                    this.loadBundle(bundle, session);
                    continue;
                }
                ++ignored;
            }
            this.log.debug("Out of {} bundles, {} were not in a suitable state for initial content loading", (Object)bundles.length, (Object)ignored);
        }
        catch (Exception t) {
            this.log.error("activate: Problem while loading initial content and registering mappings for existing bundles", (Throwable)t);
        }
        finally {
            this.ungetSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBundle(Bundle bundle, Session session) throws RepositoryException {
        try {
            this.bundleContentLoader.registerBundle(session, bundle, false);
        }
        catch (Exception t) {
            this.log.error("Problem loading initial content of bundle " + bundle.getSymbolicName() + " (" + bundle.getBundleId() + ")", (Throwable)t);
        }
        finally {
            if (session.hasPendingChanges()) {
                session.refresh(false);
            }
        }
    }

    @Deactivate
    protected synchronized void deactivate(BundleContext bundleContext) {
        bundleContext.removeBundleListener((BundleListener)this);
        if (this.bundleContentLoader != null) {
            this.bundleContentLoader.dispose();
            this.bundleContentLoader = null;
        }
    }

    protected SlingRepository getRepository() {
        return this.repository;
    }

    @Override
    public Session getSession() throws RepositoryException {
        return this.getRepository().loginService(null, null);
    }

    @Override
    public Session getSession(String workspace) throws RepositoryException {
        return this.getRepository().loginService(null, workspace);
    }

    private void ungetSession(Session session) {
        if (session != null) {
            try {
                session.logout();
            }
            catch (Exception t) {
                this.log.error("Unable to log out of session: " + t.getMessage(), (Throwable)t);
            }
        }
    }

    @Override
    public Map<String, Object> getBundleContentInfo(Session session, Bundle bundle, boolean create) throws RepositoryException {
        Node bcNode;
        String nodeName = bundle.getSymbolicName();
        Node parentNode = (Node)session.getItem(BUNDLE_CONTENT_NODE);
        if (!parentNode.hasNode(nodeName)) {
            if (!create) {
                return null;
            }
            try {
                bcNode = parentNode.addNode(nodeName, "nt:unstructured");
                bcNode.addMixin("mix:lockable");
                session.save();
            }
            catch (RepositoryException re) {
                this.log.warn("Unable to create node " + nodeName, (Throwable)re);
                session.refresh(true);
            }
        }
        if ((bcNode = parentNode.getNode(nodeName)).isLocked()) {
            return null;
        }
        try {
            LockManager lockManager = session.getWorkspace().getLockManager();
            lockManager.lock(bcNode.getPath(), false, true, Long.MAX_VALUE, null);
        }
        catch (LockException le) {
            return null;
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (bcNode.hasProperty(PROPERTY_CONTENT_LOADED_AT)) {
            info.put(PROPERTY_CONTENT_LOADED_AT, bcNode.getProperty(PROPERTY_CONTENT_LOADED_AT).getDate());
        }
        if (bcNode.hasProperty(PROPERTY_CONTENT_LOADED)) {
            info.put(PROPERTY_CONTENT_LOADED, bcNode.getProperty(PROPERTY_CONTENT_LOADED).getBoolean());
        } else {
            info.put(PROPERTY_CONTENT_LOADED, false);
        }
        if (bcNode.hasProperty(PROPERTY_UNINSTALL_PATHS)) {
            Value[] values = bcNode.getProperty(PROPERTY_UNINSTALL_PATHS).getValues();
            String[] s = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                s[i] = values[i].getString();
            }
            info.put(PROPERTY_UNINSTALL_PATHS, s);
        }
        return info;
    }

    @Override
    public void unlockBundleContentInfo(Session session, Bundle bundle, boolean contentLoaded, List<String> createdNodes) throws RepositoryException {
        String nodeName = bundle.getSymbolicName();
        Node parentNode = (Node)session.getItem(BUNDLE_CONTENT_NODE);
        Node bcNode = parentNode.getNode(nodeName);
        if (contentLoaded) {
            bcNode.setProperty(PROPERTY_CONTENT_LOADED, contentLoaded);
            bcNode.setProperty(PROPERTY_CONTENT_LOADED_AT, Calendar.getInstance());
            bcNode.setProperty(PROPERTY_CONTENT_LOADED_BY, this.slingId);
            bcNode.setProperty(PROPERTY_CONTENT_UNLOADED_AT, (String)null);
            bcNode.setProperty(PROPERTY_CONTENT_UNLOADED_BY, (String)null);
            if (createdNodes != null && !createdNodes.isEmpty()) {
                bcNode.setProperty(PROPERTY_UNINSTALL_PATHS, createdNodes.toArray(new String[createdNodes.size()]));
            }
            session.save();
        }
        LockManager lockManager = session.getWorkspace().getLockManager();
        lockManager.unlock(bcNode.getPath());
    }

    @Override
    public void contentIsUninstalled(Session session, Bundle bundle) {
        String nodeName = bundle.getSymbolicName();
        try {
            Node parentNode = (Node)session.getItem(BUNDLE_CONTENT_NODE);
            if (parentNode.hasNode(nodeName)) {
                Node bcNode = parentNode.getNode(nodeName);
                bcNode.setProperty(PROPERTY_CONTENT_LOADED, false);
                bcNode.setProperty(PROPERTY_CONTENT_UNLOADED_AT, Calendar.getInstance());
                bcNode.setProperty(PROPERTY_CONTENT_UNLOADED_BY, this.slingId);
                bcNode.setProperty(PROPERTY_UNINSTALL_PATHS, (String[])null);
                session.save();
            }
        }
        catch (RepositoryException re) {
            this.log.error("Unable to update bundle content info.", (Throwable)re);
        }
    }
}

