/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.jcr.Session;
import org.apache.jackrabbit.net.JCRJarURLConnection;
import org.apache.jackrabbit.net.JCRURLHandler;

class JCRJarURLHandler
extends JCRURLHandler {
    JCRJarURLHandler(Session session) {
        super(session);
    }

    protected URLConnection openConnection(URL url) {
        return new JCRJarURLConnection(url, this);
    }

    protected void parseURL(URL url, String spec, int start, int limit) {
        boolean emptyFile;
        String file = null;
        String ref = null;
        int hash = spec.indexOf(35, limit);
        boolean bl = emptyFile = hash == start;
        if (hash > -1) {
            ref = spec.substring(hash + 1, spec.length());
            if (emptyFile) {
                file = url.getFile();
            }
        }
        boolean isSpecAbsolute = spec.substring(0, 4).equalsIgnoreCase("jar:");
        spec = spec.substring(start, limit);
        if (isSpecAbsolute) {
            file = this.parseAbsoluteSpec(spec);
        } else if (!emptyFile) {
            file = this.parseContextSpec(url, spec);
            int bangSlash = JCRJarURLHandler.indexOfBangSlash(file);
            String archive = file.substring(0, bangSlash);
            String entry = file.substring(bangSlash);
            entry = this.canonizeString(entry);
            file = archive + entry;
        }
        this.setURL(url, "jar", "", -1, null, null, file, null, ref);
    }

    static int indexOfBangSlash(String file) {
        int i = file.length();
        while ((i = file.lastIndexOf(33, i)) != -1) {
            if (i != file.length() - 1 && file.charAt(i + 1) == '/') {
                return i + 1;
            }
            --i;
        }
        return -1;
    }

    private String parseAbsoluteSpec(String spec) {
        int bangSlash = JCRJarURLHandler.indexOfBangSlash(spec);
        if (bangSlash == -1) {
            throw new NullPointerException("no !/ in spec");
        }
        try {
            String testSpec = spec.substring(0, bangSlash - 1);
            URI uri = new URI(testSpec);
            if (!"jcr".equals(uri.getScheme())) {
                throw new URISyntaxException(testSpec, "Unsupported Scheme " + uri.getScheme(), 0);
            }
        }
        catch (URISyntaxException use) {
            throw new NullPointerException("invalid url: " + spec + " (" + use + ")");
        }
        return spec;
    }

    private String parseContextSpec(URL url, String spec) {
        String file = url.getFile();
        if (spec.startsWith("/")) {
            int bangSlash = JCRJarURLHandler.indexOfBangSlash(file);
            if (bangSlash == -1) {
                throw new NullPointerException("malformed context url:" + url + ": no !/");
            }
            file = file.substring(0, bangSlash);
        }
        if (!file.endsWith("/") && !spec.startsWith("/")) {
            int lastSlash = file.lastIndexOf(47);
            if (lastSlash == -1) {
                throw new NullPointerException("malformed context url:" + url);
            }
            file = file.substring(0, lastSlash + 1);
        }
        return file + spec;
    }

    public String canonizeString(String s) {
        int i = 0;
        int k = s.length();
        while ((i = s.indexOf("/../")) >= 0) {
            k = s.lastIndexOf(47, i - 1);
            if (k >= 0) {
                s = s.substring(0, k) + s.substring(i + 3);
                continue;
            }
            s = s.substring(i + 3);
        }
        while ((i = s.indexOf("/./")) >= 0) {
            s = s.substring(0, i) + s.substring(i + 2);
        }
        while (s.endsWith("/..")) {
            int j = s.indexOf("/..");
            int l = s.lastIndexOf(47, j - 1);
            if (l >= 0) {
                s = s.substring(0, l + 1);
                continue;
            }
            s = s.substring(0, j);
        }
        if (s.endsWith("/.")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

