/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.classloader.Util;
import org.apache.jackrabbit.net.FileParts;
import org.apache.jackrabbit.net.JCRURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRURLConnection
extends URLConnection {
    private static final Logger log = LoggerFactory.getLogger((Class)JCRURLConnection.class);
    protected static final String CONTENT_LENGTH = "content-length";
    protected static final String CONTENT_TYPE = "content-type";
    protected static final String CONTENT_ENCODING = "content-encoding";
    protected static final String LAST_MODIFIED = "last-modified";
    protected static final String APPLICATION_OCTET = "application/octet-stream";
    protected static final String TEXT_PLAIN = "text/plain";
    private final JCRURLHandler handler;
    private FileParts fileParts;
    private Item item;
    private Property property;
    private String contentType;
    private String contentEncoding;
    private int contentLength;
    private long lastModified;

    JCRURLConnection(URL url, JCRURLHandler handler) {
        super(url);
        this.handler = handler;
    }

    public Session getSession() {
        return this.handler.getSession();
    }

    public String getPath() {
        return this.getFileParts().getPath();
    }

    public Item getItem() throws IOException {
        if (this.item == null) {
            try {
                this.item = this.getSession().getItem(this.getPath());
            }
            catch (RepositoryException re) {
                throw this.failure("getItem", re.toString(), re);
            }
        }
        return this.item;
    }

    public Property getProperty() throws IOException {
        this.connect();
        return this.property;
    }

    public synchronized void connect() throws IOException {
        if (!this.connected) {
            try {
                String contentType;
                long lastModified;
                Property property = Util.getProperty((Item)this.getItem());
                if (property == null) {
                    throw this.failure("connect", "Multivalue property not supported", null);
                }
                String contentEncoding = null;
                int contentLength = (int)property.getLength();
                Node parent = property.getParent();
                if (parent.isNodeType("nt:resource")) {
                    lastModified = parent.getProperty("jcr:lastModified").getLong();
                    contentType = parent.getProperty("jcr:mimeType").getString();
                    if (parent.hasProperty("jcr:encoding")) {
                        contentEncoding = parent.getProperty("jcr:encoding").getString();
                    }
                } else {
                    lastModified = 0L;
                    contentType = JCRURLConnection.guessContentTypeFromName(this.getItem().getName());
                    if (contentType == null) {
                        contentType = property.getType() == 2 ? APPLICATION_OCTET : TEXT_PLAIN;
                    }
                }
                log.debug("connect: Using atom '" + property.getPath() + "' with content type '" + contentType + "' for " + String.valueOf(contentLength) + " bytes");
                this.setProperty(property);
                this.setContentType(contentType);
                this.setContentEncoding(contentEncoding);
                this.setContentLength(contentLength);
                this.setLastModified(lastModified);
                this.connected = true;
            }
            catch (RepositoryException re) {
                throw this.failure("connect", re.toString(), re);
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.getProperty().getStream();
        }
        catch (RepositoryException re) {
            throw this.failure("getInputStream", re.toString(), re);
        }
    }

    public String getHeaderField(String s) {
        try {
            this.connect();
            if (CONTENT_LENGTH.equalsIgnoreCase(s)) {
                return String.valueOf(this.contentLength);
            }
            if (CONTENT_TYPE.equalsIgnoreCase(s)) {
                return this.contentType;
            }
            if (LAST_MODIFIED.equalsIgnoreCase(s)) {
                return String.valueOf(this.lastModified);
            }
            if (CONTENT_ENCODING.equalsIgnoreCase(s)) {
                return this.contentEncoding;
            }
        }
        catch (IOException ioe) {
            log.info("getHeaderField: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
        }
        return null;
    }

    public String getHeaderField(int i) {
        try {
            this.connect();
            if (i == 0) {
                return String.valueOf(this.contentLength);
            }
            if (i == 1) {
                return this.contentType;
            }
            if (i == 2) {
                return String.valueOf(this.lastModified);
            }
            if (i == 3) {
                return this.contentEncoding;
            }
        }
        catch (IOException ioe) {
            log.info("getHeaderField: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
        }
        return null;
    }

    public String getHeaderFieldKey(int i) {
        try {
            this.connect();
            if (i == 0) {
                return CONTENT_LENGTH;
            }
            if (i == 1) {
                return CONTENT_TYPE;
            }
            if (i == 2) {
                return LAST_MODIFIED;
            }
            if (i == 3) {
                return CONTENT_ENCODING;
            }
        }
        catch (IOException ioe) {
            log.info("getHeaderFieldKey: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
        }
        return null;
    }

    public Map getHeaderFields() {
        HashMap<String, List> fieldMap = new HashMap<String, List>();
        try {
            this.connect();
            fieldMap.put(CONTENT_LENGTH, this.toList(String.valueOf(this.contentLength)));
            fieldMap.put(CONTENT_TYPE, this.toList(this.contentType));
            fieldMap.put(LAST_MODIFIED, this.toList(String.valueOf(this.lastModified)));
            if (this.contentEncoding != null) {
                fieldMap.put(CONTENT_ENCODING, this.toList(this.contentEncoding));
            }
        }
        catch (IOException ioe) {
            log.info("getHeaderFields: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
        }
        return Collections.unmodifiableMap(fieldMap);
    }

    public String getContentType() {
        try {
            this.connect();
            return this.contentType;
        }
        catch (IOException ioe) {
            log.info("getContentType: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
            return null;
        }
    }

    public String getContentEncoding() {
        try {
            this.connect();
            return this.contentEncoding;
        }
        catch (IOException ioe) {
            log.info("getContentEncoding: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
            return null;
        }
    }

    public int getContentLength() {
        try {
            this.connect();
            return this.contentLength;
        }
        catch (IOException ioe) {
            log.info("getContentLength: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
            return -1;
        }
    }

    public long getLastModified() {
        try {
            this.connect();
            return this.lastModified;
        }
        catch (IOException ioe) {
            log.info("getLastModified: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
            return -1L;
        }
    }

    protected JCRURLHandler getHandler() {
        return this.handler;
    }

    FileParts getFileParts() {
        if (this.fileParts == null) {
            this.fileParts = new FileParts(this.getURL().getFile());
        }
        return this.fileParts;
    }

    protected void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    protected void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    protected void setProperty(Property property) {
        this.property = property;
    }

    protected IOException failure(String method, String message, Throwable cause) {
        log.info(method + ": URL: " + this.url.toExternalForm() + ", Reason: " + message);
        if (cause != null) {
            log.debug("dump", cause);
        }
        IOException ioe = new IOException(this.url.toExternalForm() + ": " + message);
        ioe.initCause(cause);
        return ioe;
    }

    private List toList(String value) {
        String[] values = new String[]{value};
        List<String> valueList = Arrays.asList(values);
        return Collections.unmodifiableList(valueList);
    }
}

