/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource;

import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.internal.helper.LazyInputStream;

public class JcrResourceUtil {
    public static QueryResult query(Session session, String query, String language) throws RepositoryException {
        QueryManager qManager = session.getWorkspace().getQueryManager();
        Query q = qManager.createQuery(query, language);
        return q.execute();
    }

    public static Object toJavaObject(Value value) throws RepositoryException {
        switch (value.getType()) {
            case 2: {
                return new LazyInputStream(value);
            }
            case 6: {
                return value.getBoolean();
            }
            case 5: {
                return value.getDate();
            }
            case 4: {
                return value.getDouble();
            }
            case 3: {
                return value.getLong();
            }
        }
        return value.getString();
    }

    public static Object toJavaObject(Property property) throws RepositoryException {
        if (property.getDefinition().isMultiple()) {
            Value[] values = property.getValues();
            Object[] result = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                if (value == null) continue;
                result[i] = JcrResourceUtil.toJavaObject(value);
            }
            return result;
        }
        return JcrResourceUtil.toJavaObject(property.getValue());
    }

    public static String resourceTypeToPath(String type) {
        return type.replaceAll("\\:", "/");
    }

    public static String getResourceSuperType(ResourceResolver resourceResolver, String resourceType) {
        String rtPath = JcrResourceUtil.resourceTypeToPath(resourceType);
        Resource rtResource = resourceResolver.getResource(rtPath = rtPath + "/sling:resourceSuperType");
        return rtResource != null ? (String)rtResource.adaptTo(String.class) : null;
    }

    public static String getResourceSuperType(Resource resource) {
        ResourceResolver resolver = resource.getResourceResolver();
        String resourceSuperType = null;
        Resource typeResource = resolver.getResource(resource, "sling:resourceSuperType");
        if (typeResource != null) {
            resourceSuperType = (String)typeResource.adaptTo(String.class);
        }
        if (resourceSuperType == null) {
            String resourceType = resource.getResourceType();
            resourceSuperType = JcrResourceUtil.getResourceSuperType(resolver, resourceType);
        }
        return resourceSuperType;
    }
}

