/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.adapter.SlingAdaptable;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl;
import org.apache.sling.jcr.resource.internal.helper.Mapping;
import org.apache.sling.jcr.resource.internal.helper.ResourcePathIterator;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResourceIterator;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderEntry;
import org.apache.sling.jcr.resource.internal.helper.starresource.StarResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceResolver
extends SlingAdaptable
implements ResourceResolver {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JcrResourceProviderEntry rootProvider;
    private final JcrResourceResolverFactoryImpl factory;

    public JcrResourceResolver(JcrResourceProviderEntry rootProvider, JcrResourceResolverFactoryImpl factory) {
        this.rootProvider = rootProvider;
        this.factory = factory;
    }

    public Resource resolve(HttpServletRequest request) throws SlingException {
        Object result;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        if ((result = this.resolve(pathInfo)) == null) {
            result = StarResource.appliesTo(request) ? new StarResource(this, pathInfo, this.rootProvider.getResourceTypeProviders()) : new NonExistingResource((ResourceResolver)this, pathInfo);
        }
        return result;
    }

    public Resource resolve(String uri) throws SlingException {
        String realUrl = this.factory.virtualToRealUri(uri);
        if (realUrl != null) {
            this.log.debug("resolve: Using real url '{}' for virtual url '{}'", (Object)realUrl, (Object)uri);
            uri = realUrl;
        }
        try {
            Resource result = this.urlToResource(uri);
            return result;
        }
        catch (SlingException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SlingException("Problem resolving " + uri, t);
        }
    }

    public String map(String resourcePath) {
        String virtual;
        String href = null;
        Mapping[] mappings = this.factory.getMappings();
        for (int i = 0; i < mappings.length && href == null; ++i) {
            href = mappings[i].mapHandle(resourcePath);
        }
        if (href == null) {
            href = resourcePath;
        }
        if ((virtual = this.factory.realToVirtualUri(href)) != null) {
            this.log.debug("map: Using virtual URI {} for path {}", (Object)virtual, (Object)href);
            href = virtual;
        }
        this.log.debug("map: {} -> {}", (Object)resourcePath, (Object)href);
        return href;
    }

    public Resource getResource(String path) {
        if (path.startsWith("/")) {
            return (path = ResourceUtil.normalize((String)path)) != null ? this.getResourceInternal(path) : null;
        }
        for (String prefix : this.factory.getSearchPath()) {
            Resource res = this.getResource(prefix + path);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public Resource getResource(Resource base, String path) {
        if (!path.startsWith("/") && base != null) {
            path = base.getPath() + "/" + path;
        }
        return this.getResource(path);
    }

    public String[] getSearchPath() {
        return (String[])this.factory.getSearchPath().clone();
    }

    public Iterator<Resource> listChildren(Resource parent) {
        return this.rootProvider.listChildren(parent);
    }

    public Iterator<Resource> findResources(String query, String language) throws SlingException {
        try {
            QueryResult res = JcrResourceUtil.query(this.getSession(), query, language);
            return new JcrNodeResourceIterator(this, res.getNodes(), this.rootProvider.getResourceTypeProviders());
        }
        catch (InvalidQueryException iqe) {
            throw new QuerySyntaxException(iqe.getMessage(), query, language, (Throwable)iqe);
        }
        catch (RepositoryException re) {
            throw new SlingException(re.getMessage(), (Throwable)re);
        }
    }

    public Iterator<Map<String, Object>> queryResources(String query, String language) throws SlingException {
        try {
            QueryResult result = JcrResourceUtil.query(this.getSession(), query, language);
            final String[] colNames = result.getColumnNames();
            final RowIterator rows = result.getRows();
            return new Iterator<Map<String, Object>>(){

                @Override
                public boolean hasNext() {
                    return rows.hasNext();
                }

                @Override
                public Map<String, Object> next() {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    try {
                        Value[] values = rows.nextRow().getValues();
                        for (int i = 0; i < values.length; ++i) {
                            Value v = values[i];
                            if (v == null) continue;
                            row.put(colNames[i], JcrResourceUtil.toJavaObject(values[i]));
                        }
                    }
                    catch (RepositoryException re) {
                        JcrResourceResolver.this.log.error("queryResources$next: Problem accessing row values", (Throwable)re);
                    }
                    return row;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }
        catch (InvalidQueryException iqe) {
            throw new QuerySyntaxException(iqe.getMessage(), query, language, (Throwable)iqe);
        }
        catch (RepositoryException re) {
            throw new SlingException(re.getMessage(), (Throwable)re);
        }
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Session.class) {
            return (AdapterType)this.getSession();
        }
        return (AdapterType)super.adaptTo(type);
    }

    public Session getSession() {
        return this.rootProvider.getSession();
    }

    private Resource urlToResource(String uri) throws SlingException {
        Mapping[] mappings = this.factory.getMappings();
        for (int i = 0; i < mappings.length; ++i) {
            String mappedUri = mappings[i].mapUri(uri);
            if (mappedUri == null) {
                this.log.debug("Mapping {} cannot map {}", (Object)mappings[i], (Object)uri);
                continue;
            }
            Resource resource = this.scanPath(mappedUri);
            if (resource != null) {
                ResourceMetadata rm = resource.getResourceMetadata();
                String path = rm.getResolutionPath();
                String uriPath = mappings[i].mapHandle(path);
                if (uriPath != null && !uriPath.equals(path)) {
                    resource.getResourceMetadata().setResolutionPath(uriPath);
                }
                return resource;
            }
            this.log.debug("Cannot resolve {} to resource", (Object)mappedUri);
        }
        this.log.info("Could not resolve URL {} to a Resource", (Object)uri);
        return null;
    }

    private Resource scanPath(String uriPath) throws SlingException {
        Resource resource = null;
        String curPath = uriPath;
        try {
            ResourcePathIterator it = new ResourcePathIterator(uriPath);
            while (it.hasNext() && resource == null) {
                curPath = it.next();
                resource = this.getResourceInternal(curPath);
            }
        }
        catch (Exception ex) {
            throw new SlingException("Problem trying " + curPath + " for request path " + uriPath, (Throwable)ex);
        }
        return resource;
    }

    protected Resource getResourceInternal(String path) {
        Resource resource = this.rootProvider.getResource(this, path);
        if (resource != null) {
            resource.getResourceMetadata().setResolutionPath(path);
            return resource;
        }
        this.log.debug("Cannot resolve path '{}' to a resource", (Object)path);
        return null;
    }
}

