/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Session;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.apache.sling.jcr.resource.JcrResourceTypeProvider;
import org.apache.sling.jcr.resource.internal.JcrResourceResolver;
import org.apache.sling.jcr.resource.internal.helper.Mapping;
import org.apache.sling.jcr.resource.internal.helper.ResourceProviderEntry;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceResolverFactoryImpl
implements JcrResourceResolverFactory {
    private static final String PROP_ALLOW_DIRECT = "resource.resolver.allowDirect";
    private static final String PROP_VIRTUAL = "resource.resolver.virtual";
    private static final String PROP_MAPPING = "resource.resolver.mapping";
    public static final String PROP_PATH = "resource.resolver.searchpath";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SlingRepository repository;
    private EventAdmin eventAdmin;
    protected final List<JcrResourceTypeProviderEntry> jcrResourceTypeProviders = new ArrayList<JcrResourceTypeProviderEntry>();
    private final List<ServiceReference> delayedResourceProviders = new LinkedList<ServiceReference>();
    protected List<ServiceReference> delayedJcrResourceTypeProviders = new LinkedList<ServiceReference>();
    protected ComponentContext componentContext;
    private ServiceReference serviceReference;
    private Mapping[] mappings;
    private BidiMap virtualURLMap;
    private boolean allowDirect = false;
    private String[] searchPath;
    private ResourceProviderEntry rootProviderEntry = new ResourceProviderEntry("/", null, null);

    @Override
    public ResourceResolver getResourceResolver(Session session) {
        JcrResourceProviderEntry sessionRoot = new JcrResourceProviderEntry(session, this.rootProviderEntry.getEntries(), this.getJcrResourceTypeProvider());
        return new JcrResourceResolver(sessionRoot, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JcrResourceTypeProvider[] getJcrResourceTypeProvider() {
        JcrResourceTypeProvider[] providers = null;
        List<JcrResourceTypeProviderEntry> list = this.jcrResourceTypeProviders;
        synchronized (list) {
            if (this.jcrResourceTypeProviders.size() > 0) {
                providers = new JcrResourceTypeProvider[this.jcrResourceTypeProviders.size()];
                int index = 0;
                Iterator<JcrResourceTypeProviderEntry> i = this.jcrResourceTypeProviders.iterator();
                while (i.hasNext()) {
                    providers[index] = i.next().provider;
                }
            }
        }
        return providers;
    }

    public void fireEvent(Bundle sourceBundle, String eventName, Map<String, Object> props) {
        EventAdmin ea = this.eventAdmin;
        if (ea == null) {
            return;
        }
        Hashtable<String, Object> table = new Hashtable<String, Object>(props);
        ServiceReference sr = this.serviceReference;
        if (sr != null) {
            ((Dictionary)table).put("service", sr);
            ((Dictionary)table).put("service.id", sr.getProperty("service.id"));
            ((Dictionary)table).put("service.objectClass", sr.getProperty("objectClass"));
            if (sr.getProperty("service.pid") != null) {
                ((Dictionary)table).put("service.pid", sr.getProperty("service.pid"));
            }
        }
        if (sourceBundle != null) {
            ((Dictionary)table).put("bundle.symbolicName", sourceBundle.getSymbolicName());
        }
        ((Dictionary)table).put("timestamp", new Long(System.currentTimeMillis()));
        ea.postEvent(new Event(eventName, table));
    }

    String virtualToRealUri(String virtualUri) {
        return this.virtualURLMap != null ? (String)this.virtualURLMap.get((Object)virtualUri) : null;
    }

    String realToVirtualUri(String realUri) {
        return this.virtualURLMap != null ? (String)this.virtualURLMap.getKey((Object)realUri) : null;
    }

    Mapping[] getMappings() {
        return this.mappings;
    }

    String[] getSearchPath() {
        return this.searchPath;
    }

    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.serviceReference = componentContext.getServiceReference();
        Dictionary properties = componentContext.getProperties();
        TreeBidiMap virtuals = new TreeBidiMap();
        String[] virtualList = (String[])properties.get(PROP_VIRTUAL);
        for (int i = 0; virtualList != null && i < virtualList.length; ++i) {
            String[] parts = Mapping.split(virtualList[i]);
            virtuals.put((Object)parts[0], (Object)parts[2]);
        }
        this.virtualURLMap = virtuals;
        ArrayList<Mapping> maps = new ArrayList<Mapping>();
        String[] mappingList = (String[])properties.get(PROP_MAPPING);
        for (int i = 0; mappingList != null && i < mappingList.length; ++i) {
            maps.add(new Mapping(mappingList[i]));
        }
        Mapping[] tmp = maps.toArray(new Mapping[maps.size()]);
        Boolean directProp = (Boolean)properties.get(PROP_ALLOW_DIRECT);
        boolean bl = this.allowDirect = directProp != null ? directProp : true;
        if (this.allowDirect) {
            Mapping[] tmp2 = new Mapping[tmp.length + 1];
            tmp2[0] = Mapping.DIRECT;
            System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
            this.mappings = tmp2;
        } else {
            this.mappings = tmp;
        }
        this.searchPath = OsgiUtil.toStringArray(properties.get(PROP_PATH));
        if (this.searchPath != null && this.searchPath.length > 0) {
            for (int i = 0; i < this.searchPath.length; ++i) {
                if (!this.searchPath[i].startsWith("/")) {
                    this.searchPath[i] = "/" + this.searchPath[i];
                }
                if (this.searchPath[i].endsWith("/")) continue;
                int n = i;
                this.searchPath[n] = this.searchPath[n] + "/";
            }
        }
        if (this.searchPath == null) {
            this.searchPath = new String[]{"/"};
        }
        for (ServiceReference reference : this.delayedResourceProviders) {
            this.bindResourceProvider(reference);
        }
        this.delayedResourceProviders.clear();
        this.processDelayedJcrResourceTypeProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDelayedJcrResourceTypeProviders() {
        List<JcrResourceTypeProviderEntry> list = this.jcrResourceTypeProviders;
        synchronized (list) {
            for (ServiceReference reference : this.delayedJcrResourceTypeProviders) {
                this.addJcrResourceTypeProvider(reference);
            }
            this.delayedJcrResourceTypeProviders.clear();
        }
    }

    protected void addJcrResourceTypeProvider(ServiceReference reference) {
        Long id = (Long)reference.getProperty("service.id");
        long ranking = -1L;
        if (reference.getProperty("service.ranking") != null) {
            ranking = (Long)reference.getProperty("service.ranking");
        }
        this.jcrResourceTypeProviders.add(new JcrResourceTypeProviderEntry(id, ranking, (JcrResourceTypeProvider)this.componentContext.locateService("JcrResourceTypeProvider", reference)));
        Collections.sort(this.jcrResourceTypeProviders, new Comparator<JcrResourceTypeProviderEntry>(){

            @Override
            public int compare(JcrResourceTypeProviderEntry o1, JcrResourceTypeProviderEntry o2) {
                if (o1.ranking < o2.ranking) {
                    return 1;
                }
                if (o1.ranking > o2.ranking) {
                    return -1;
                }
                if (o1.serviceId < o2.serviceId) {
                    return -1;
                }
                if (o1.serviceId > o2.serviceId) {
                    return 1;
                }
                return 0;
            }
        });
    }

    protected void deactivate(ComponentContext componentContext) {
        this.componentContext = null;
    }

    protected void bindResourceProvider(ServiceReference reference) {
        if (this.componentContext == null) {
            this.delayedResourceProviders.add(reference);
        } else {
            String[] roots = OsgiUtil.toStringArray((Object)reference.getProperty("provider.roots"));
            if (roots != null && roots.length > 0) {
                ResourceProvider provider = (ResourceProvider)this.componentContext.locateService("ResourceProvider", reference);
                for (String root : roots) {
                    try {
                        this.rootProviderEntry.addResourceProvider(root, provider);
                    }
                    catch (IllegalStateException ise) {
                        this.log.error("bindResourceProvider: A ResourceProvider for {} is already registered", (Object)root);
                    }
                }
            }
        }
    }

    protected void unbindResourceProvider(ServiceReference reference) {
        String[] roots = OsgiUtil.toStringArray((Object)reference.getProperty("provider.roots"));
        if (roots != null && roots.length > 0) {
            for (String root : roots) {
                this.rootProviderEntry.removeResourceProvider(root);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindJcrResourceTypeProvider(ServiceReference reference) {
        List<JcrResourceTypeProviderEntry> list = this.jcrResourceTypeProviders;
        synchronized (list) {
            if (this.componentContext == null) {
                this.delayedJcrResourceTypeProviders.add(reference);
            } else {
                this.addJcrResourceTypeProvider(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindJcrResourceTypeProvider(ServiceReference reference) {
        List<JcrResourceTypeProviderEntry> list = this.jcrResourceTypeProviders;
        synchronized (list) {
            this.delayedJcrResourceTypeProviders.remove(reference);
            long id = (Long)reference.getProperty("service.id");
            Iterator<JcrResourceTypeProviderEntry> i = this.jcrResourceTypeProviders.iterator();
            while (i.hasNext()) {
                JcrResourceTypeProviderEntry current = i.next();
                if (current.serviceId != id) continue;
                i.remove();
            }
        }
    }

    protected SlingRepository getRepository() {
        return this.repository;
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected static final class JcrResourceTypeProviderEntry {
        final long serviceId;
        final long ranking;
        final JcrResourceTypeProvider provider;

        public JcrResourceTypeProviderEntry(long id, long ranking, JcrResourceTypeProvider p) {
            this.serviceId = id;
            this.ranking = ranking;
            this.provider = p;
        }
    }
}

