/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceTypeProvider;
import org.apache.sling.jcr.resource.JcrResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JcrItemResource
extends SlingAdaptable
implements Resource {
    private static final String UNSET_RESOURCE_SUPER_TYPE = "<unset>";
    private final ResourceResolver resourceResolver;
    private final String path;
    private final ResourceMetadata metadata;
    private String resourceSuperType;
    protected final JcrResourceTypeProvider[] resourceTypeProviders;

    protected JcrItemResource(ResourceResolver resourceResolver, String path, JcrResourceTypeProvider[] resourceTypeProviders) {
        this.resourceResolver = resourceResolver;
        this.path = path;
        this.resourceTypeProviders = resourceTypeProviders;
        this.metadata = new ResourceMetadata();
        this.metadata.setResolutionPath(path);
        this.resourceSuperType = UNSET_RESOURCE_SUPER_TYPE;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceSuperType() {
        if (this.resourceSuperType == UNSET_RESOURCE_SUPER_TYPE) {
            this.resourceSuperType = JcrResourceUtil.getResourceSuperType(this);
        }
        return this.resourceSuperType;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    protected String getResourceTypeForNode(Node node) throws RepositoryException {
        String result = null;
        if (node.hasProperty("sling:resourceType")) {
            result = node.getProperty("sling:resourceType").getValue().getString();
        }
        if (result == null && this.resourceTypeProviders != null) {
            for (int index = 0; result == null && index < this.resourceTypeProviders.length; ++index) {
                result = this.resourceTypeProviders[index].getResourceTypeForNode(node);
            }
        }
        if (result == null || result.length() == 0) {
            result = node.getPrimaryNodeType().getName();
        }
        return result;
    }

    abstract Iterator<Resource> listChildren();
}

