/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.net.URLFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceTypeProvider;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResourceIterator;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrPropertyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrNodeResource
extends JcrItemResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Node node;
    private final String resourceType;

    JcrNodeResource(ResourceResolver resourceResolver, Node node, JcrResourceTypeProvider[] resourceTypeProviders) throws RepositoryException {
        super(resourceResolver, node.getPath(), resourceTypeProviders);
        this.node = node;
        this.resourceType = this.getResourceTypeForNode(node);
        this.setMetaData(node, this.getResourceMetadata());
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public <Type> Type adaptTo(Class<Type> type) {
        if (type == Node.class || type == Item.class) {
            return (Type)this.getNode();
        }
        if (type == InputStream.class) {
            return (Type)this.getInputStream();
        }
        if (type == URL.class) {
            return (Type)this.getURL();
        }
        if (type == Map.class) {
            return (Type)new JcrPropertyMap(this.getNode());
        }
        return (Type)super.adaptTo(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", type=" + this.getResourceType() + ", path=" + this.getPath();
    }

    private Node getNode() {
        return this.node;
    }

    private InputStream getInputStream() {
        if (this.node != null) {
            try {
                Property data;
                Node content;
                Node node = content = this.node.isNodeType("nt:file") ? this.node.getNode("jcr:content") : this.node;
                if (content.hasProperty("jcr:data")) {
                    data = content.getProperty("jcr:data");
                } else {
                    try {
                        Item item = content.getPrimaryItem();
                        while (item.isNode()) {
                            item = ((Node)item).getPrimaryItem();
                        }
                        data = (Property)item;
                    }
                    catch (ItemNotFoundException infe) {
                        this.log.debug("getInputStream: No primary items for " + this.toString(), (Throwable)infe);
                        data = null;
                    }
                }
                if (data != null) {
                    long length = data.getLength();
                    InputStream stream = data.getStream();
                    this.getResourceMetadata().setContentLength(length);
                    return stream;
                }
            }
            catch (RepositoryException re) {
                this.log.error("getInputStream: Cannot get InputStream for " + (Object)((Object)this), (Throwable)re);
            }
        }
        return null;
    }

    private URL getURL() {
        try {
            return URLFactory.createURL(this.node.getSession(), this.node.getPath());
        }
        catch (Exception ex) {
            this.log.error("getURL: Cannot create URL for " + (Object)((Object)this), (Throwable)ex);
            return null;
        }
    }

    @Override
    Iterator<Resource> listChildren() {
        try {
            if (this.getNode().hasNodes()) {
                return new JcrNodeResourceIterator(this.getResourceResolver(), this.getNode().getNodes(), this.resourceTypeProviders);
            }
        }
        catch (RepositoryException re) {
            this.log.error("listChildren: Cannot get children of " + (Object)((Object)this), (Throwable)re);
        }
        return Collections.emptyList().iterator();
    }

    private void setMetaData(Node node, ResourceMetadata metadata) {
        try {
            if (node.isNodeType("nt:file")) {
                metadata.setCreationTime(node.getProperty("jcr:created").getLong());
                node = node.getNode("jcr:content");
            }
            if (node.hasProperty("jcr:mimeType")) {
                metadata.setContentType(node.getProperty("jcr:mimeType").getString());
            }
            if (node.hasProperty("jcr:encoding")) {
                metadata.setCharacterEncoding(node.getProperty("jcr:encoding").getString());
            }
            if (node.hasProperty("jcr:lastModified")) {
                metadata.setModificationTime(node.getProperty("jcr:lastModified").getLong());
            }
        }
        catch (RepositoryException re) {
            this.log.info("setMetaData: Problem extracting metadata information for " + this.getPath(), (Throwable)re);
        }
    }
}

