/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.sling.jcr.resource.JcrResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JcrPropertyMap
implements Map<String, Object> {
    private final Node node;
    private final Map<String, Object> cache;
    private boolean fullyRead;

    JcrPropertyMap(Node node) {
        this.node = node;
        this.cache = new HashMap<String, Object>();
        this.fullyRead = false;
    }

    @Override
    public Object get(Object key) {
        Object value = this.cache.get(key);
        if (value == null) {
            value = this.read((String)key);
        }
        return value;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        this.readFully();
        return this.cache.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        if (this.cache.isEmpty()) {
            this.readFully();
        }
        return this.cache.isEmpty();
    }

    @Override
    public int size() {
        this.readFully();
        return this.cache.size();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.readFully();
        return this.cache.entrySet();
    }

    @Override
    public Set<String> keySet() {
        this.readFully();
        return this.cache.keySet();
    }

    @Override
    public Collection<Object> values() {
        this.readFully();
        return this.cache.values();
    }

    private Object read(String key) {
        if (this.fullyRead) {
            return null;
        }
        try {
            if (this.node.hasProperty(key)) {
                Property prop = this.node.getProperty(key);
                Object value = JcrResourceUtil.toJavaObject(prop);
                this.cache.put(key, value);
                return value;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    private void readFully() {
        if (!this.fullyRead) {
            try {
                PropertyIterator pi = this.node.getProperties();
                while (pi.hasNext()) {
                    Property prop = pi.nextProperty();
                    String key = prop.getName();
                    if (this.cache.containsKey(key)) continue;
                    this.cache.put(key, JcrResourceUtil.toJavaObject(prop));
                }
                this.fullyRead = true;
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }
}

