/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceTypeProvider;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrPropertyResource
extends JcrItemResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Property property;
    private final String resourceType;

    public JcrPropertyResource(ResourceResolver resourceResolver, String path, Property property, JcrResourceTypeProvider[] resourceTypeProviders) throws RepositoryException {
        super(resourceResolver, path, resourceTypeProviders);
        this.property = property;
        this.resourceType = this.getResourceTypeForNode(property.getParent()) + "/" + property.getName();
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Property.class || type == Item.class) {
            return (AdapterType)this.property;
        }
        try {
            if (type == String.class) {
                return (AdapterType)this.getProperty().getString();
            }
            if (type == Boolean.class) {
                return (AdapterType)new Boolean(this.getProperty().getBoolean());
            }
            if (type == Long.class) {
                return (AdapterType)new Long(this.getProperty().getLong());
            }
            if (type == Double.class) {
                return (AdapterType)new Double(this.getProperty().getDouble());
            }
            if (type == Calendar.class) {
                return (AdapterType)this.getProperty().getDate();
            }
            if (type == Value.class) {
                return (AdapterType)this.getProperty().getValue();
            }
            if (type == Node.class && this.getProperty().getType() == 9) {
                return (AdapterType)this.getProperty().getNode();
            }
            if (type == InputStream.class) {
                return (AdapterType)this.getInputStream();
            }
        }
        catch (ValueFormatException vfe) {
            this.log.info("adaptTo: Problem accessing the property value of {}: {}", (Object)this.getPath(), (Object)vfe.getMessage());
            this.log.debug("adaptTo: Cause", (Throwable)vfe);
        }
        catch (RepositoryException re) {
            this.log.info("adaptTo: Problem accessing the property " + this.getPath(), (Throwable)re);
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", type=" + this.getResourceType() + ", path=" + this.getPath();
    }

    private Property getProperty() {
        return this.property;
    }

    private InputStream getInputStream() {
        Property prop = this.getProperty();
        try {
            long length = prop.getLength();
            InputStream stream = prop.getStream();
            this.getResourceMetadata().setContentLength(length);
            return stream;
        }
        catch (RepositoryException re) {
            this.log.error("getInputStream: Problem accessing the property " + this.getPath() + " stream", (Throwable)re);
            return null;
        }
    }

    @Override
    Iterator<Resource> listChildren() {
        return null;
    }
}

