/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.starresource;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.jcr.resource.JcrResourceTypeProvider;
import org.apache.sling.jcr.resource.internal.helper.starresource.FakeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarResource
extends SyntheticResource {
    public static final String PATH_PATTERN = "/*.";
    public static final String PATH_CLEAN_SUFFIX = "/*";
    public static final String DEFAULT_RESOURCE_TYPE = "sling:syntheticStarResource";

    public static boolean appliesTo(HttpServletRequest request) {
        String path = request.getPathInfo();
        return path.contains(PATH_PATTERN) || path.endsWith(PATH_CLEAN_SUFFIX);
    }

    public static boolean isStarResource(Resource res) {
        return res.getPath().endsWith(PATH_CLEAN_SUFFIX);
    }

    public StarResource(ResourceResolver resourceResolver, String path, JcrResourceTypeProvider[] jcrProviders) throws SlingException {
        super(resourceResolver, StarResource.convertPath(path), null);
        FakeNode n = new FakeNode(this.getPath());
        String resourceType = null;
        if (jcrProviders != null) {
            try {
                for (int index = 0; resourceType == null && index < jcrProviders.length; ++index) {
                    resourceType = jcrProviders[index].getResourceTypeForNode(n);
                }
            }
            catch (RepositoryException re) {
                throw new SyntheticStarResourceException("getResourceTypeForNode failed", re);
            }
        }
        if (resourceType == null) {
            resourceType = DEFAULT_RESOURCE_TYPE;
        }
        this.setResourceType(resourceType);
    }

    public <Type> Type adaptTo(Class<Type> type) {
        if (type == Node.class) {
            return (Type)new FakeNode(this.getPath());
        }
        return null;
    }

    protected static String convertPath(String path) {
        int index = path.indexOf(PATH_PATTERN);
        if (index >= 0) {
            return path.substring(0, index) + PATH_CLEAN_SUFFIX;
        }
        return path;
    }

    static class SyntheticStarResourceException
    extends SlingException {
        SyntheticStarResourceException(String reason, Throwable cause) {
            super(reason, cause);
        }
    }
}

