/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.internal.ObservationListenerSupport;
import org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceListener
implements EventListener,
Closeable {
    private final Logger logger = LoggerFactory.getLogger(JcrResourceListener.class);
    private final String mountPrefix;
    private final boolean hasJackrabbitEventClass;
    private final LinkedBlockingQueue<Map<String, Object>> osgiEventQueue;
    final ObservationListenerSupport support;
    private final PathMapper pathMapper;
    private final Map<String, Object> TERMINATE_PROCESSING = new HashMap<String, Object>(1);

    public JcrResourceListener(String mountPrefix, ObservationListenerSupport support, PathMapper pathMapper) throws RepositoryException {
        this.pathMapper = pathMapper;
        boolean foundClass = false;
        try {
            this.getClass().getClassLoader().loadClass(JackrabbitEvent.class.getName());
            foundClass = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.hasJackrabbitEventClass = foundClass;
        this.mountPrefix = mountPrefix == null || mountPrefix.length() == 0 || mountPrefix.equals("/") ? null : mountPrefix;
        this.support = support;
        this.support.getSession().getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, "/", true, null, null, false);
        this.osgiEventQueue = new LinkedBlockingQueue();
        Thread oeqt = new Thread(new Runnable(){

            public void run() {
                JcrResourceListener.this.processOsgiEventQueue();
            }
        }, "Apache Sling JCR Resource Event Queue Processor");
        oeqt.start();
    }

    @Override
    public void close() throws IOException {
        try {
            this.support.getSession().getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException e) {
            this.logger.warn("Unable to remove session listener: " + this, (Throwable)e);
        }
        this.osgiEventQueue.clear();
        this.osgiEventQueue.offer(this.TERMINATE_PROCESSING);
        this.support.dispose();
    }

    public void onEvent(EventIterator events) {
        EventAdmin localEA = this.support.getEventAdmin();
        if (localEA == null) {
            return;
        }
        HashMap<String, Map<String, Object>> addedEvents = new HashMap<String, Map<String, Object>>();
        HashMap<String, ChangedAttributes> changedEvents = new HashMap<String, ChangedAttributes>();
        HashMap<String, Map<String, Object>> removedEvents = new HashMap<String, Map<String, Object>>();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                String eventPath = this.mountPrefix != null ? this.mountPrefix + event.getPath() : event.getPath();
                if (event.getType() == 4 || event.getType() == 8 || event.getType() == 16) {
                    int lastSlash = eventPath.lastIndexOf(47);
                    String nodePath = eventPath.substring(0, lastSlash);
                    String propName = eventPath.substring(lastSlash + 1);
                    this.updateChangedEvent(changedEvents, nodePath, event, propName);
                    continue;
                }
                if (event.getType() == 1) {
                    addedEvents.put(eventPath, this.createEventProperties(event));
                    continue;
                }
                if (event.getType() != 2) continue;
                addedEvents.remove(eventPath);
                removedEvents.put(eventPath, this.createEventProperties(event));
            }
            catch (RepositoryException e) {
                this.logger.error("Error during modification: {}", (Object)e.getMessage());
            }
        }
        for (Map.Entry e : removedEvents.entrySet()) {
            this.sendOsgiEvent((String)e.getKey(), (Map)e.getValue(), "org/apache/sling/api/resource/Resource/REMOVED", null);
        }
        for (Map.Entry e : addedEvents.entrySet()) {
            this.sendOsgiEvent((String)e.getKey(), (Map)e.getValue(), "org/apache/sling/api/resource/Resource/ADDED", (ChangedAttributes)changedEvents.remove(e.getKey()));
        }
        for (Map.Entry e : changedEvents.entrySet()) {
            this.sendOsgiEvent((String)e.getKey(), ((ChangedAttributes)e.getValue()).toEventProperties(), "org/apache/sling/api/resource/Resource/CHANGED", null);
        }
    }

    private void updateChangedEvent(Map<String, ChangedAttributes> changedEvents, String path, Event event, String propName) {
        ChangedAttributes storedEvent = changedEvents.get(path);
        if (storedEvent == null) {
            storedEvent = new ChangedAttributes(this.createEventProperties(event));
            changedEvents.put(path, storedEvent);
        }
        storedEvent.addEvent(event, propName);
    }

    private Map<String, Object> createEventProperties(Event event) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.isExternal(event)) {
            properties.put("event.application", "unknown");
        } else {
            String userID = event.getUserID();
            if (userID != null) {
                properties.put("userid", userID);
            }
        }
        return properties;
    }

    private void sendOsgiEvent(String path, Map<String, Object> properties, String topic, ChangedAttributes changedAttributes) {
        String resourcePath = this.pathMapper.mapJCRPathToResourcePath(path);
        if (resourcePath != null) {
            if (changedAttributes != null) {
                changedAttributes.mergeAttributesInto(properties);
            }
            properties.put("path", resourcePath);
            properties.put("event.topics", topic);
            this.osgiEventQueue.offer(properties);
        } else {
            this.logger.error("Dropping observation event for {}", (Object)path);
        }
    }

    void processOsgiEventQueue() {
        while (true) {
            Map<String, Object> event;
            try {
                event = this.osgiEventQueue.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (event == null || event == this.TERMINATE_PROCESSING) break;
            try {
                EventAdmin localEa = this.support.getEventAdmin();
                ResourceResolver resolver = this.support.getResourceResolver();
                if (localEa == null || resolver == null) continue;
                String topic = (String)event.remove("event.topics");
                String path = (String)event.get("path");
                Resource resource = resolver.getResource(path);
                boolean sendEvent = true;
                if (!"org/apache/sling/api/resource/Resource/REMOVED".equals(topic)) {
                    if (resource != null) {
                        Node node = (Node)resource.adaptTo(Node.class);
                        if (node != null) {
                            String resourceSuperType;
                            String resourceType;
                            if (path.endsWith("/jcr:content")) {
                                try {
                                    Resource parentResource;
                                    if (node.getParent().isNodeType("nt:file") && (parentResource = resource.getParent()) != null) {
                                        resource = parentResource;
                                        event.put("path", resource.getPath());
                                    }
                                }
                                catch (RepositoryException re) {
                                    // empty catch block
                                }
                            }
                            if ((resourceType = resource.getResourceType()) != null) {
                                event.put("resourceType", resource.getResourceType());
                            }
                            if ((resourceSuperType = resource.getResourceSuperType()) != null) {
                                event.put("resourceSuperType", resource.getResourceSuperType());
                            }
                        } else {
                            sendEvent = false;
                        }
                    } else {
                        this.logger.debug("processOsgiEventQueue: Resource at {} not found, which is not expected for an added or modified node", (Object)path);
                        sendEvent = false;
                    }
                }
                if (!sendEvent) continue;
                localEa.sendEvent(new org.osgi.service.event.Event(topic, (Map)new EventProperties(event)));
            }
            catch (Exception e) {
                this.logger.warn("processOsgiEventQueue: Unexpected problem processing event " + event, (Throwable)e);
            }
        }
        this.osgiEventQueue.clear();
    }

    private boolean isExternal(Event event) {
        if (this.hasJackrabbitEventClass && event instanceof JackrabbitEvent) {
            JackrabbitEvent jEvent = (JackrabbitEvent)event;
            return jEvent.isExternal();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangedAttributes {
        private final Map<String, Object> properties;
        public Set<String> addedAttributes;
        public Set<String> changedAttributes;
        public Set<String> removedAttributes;

        public ChangedAttributes(Map<String, Object> properties) {
            this.properties = properties;
        }

        public void addEvent(Event event, String propName) {
            if (event.getType() == 4) {
                if (this.removedAttributes != null) {
                    this.removedAttributes.remove(propName);
                }
                if (this.addedAttributes == null) {
                    this.addedAttributes = new HashSet<String>();
                }
                this.addedAttributes.add(propName);
            } else if (event.getType() == 8) {
                if (this.addedAttributes != null) {
                    this.addedAttributes.remove(propName);
                }
                if (this.removedAttributes == null) {
                    this.removedAttributes = new HashSet<String>();
                }
                this.removedAttributes.add(propName);
            } else if (event.getType() == 16) {
                if (this.changedAttributes == null) {
                    this.changedAttributes = new HashSet<String>();
                }
                this.changedAttributes.add(propName);
            }
        }

        public final Map<String, Object> mergeAttributesInto(Map<String, Object> properties) {
            if (this.addedAttributes != null) {
                properties.put("resourceAddedAttributes", this.addedAttributes.toArray(new String[this.addedAttributes.size()]));
            }
            if (this.changedAttributes != null) {
                properties.put("resourceChangedAttributes", this.changedAttributes.toArray(new String[this.changedAttributes.size()]));
            }
            if (this.removedAttributes != null) {
                properties.put("resourceRemovedAttributes", this.removedAttributes.toArray(new String[this.removedAttributes.size()]));
            }
            return properties;
        }

        public final Map<String, Object> toEventProperties() {
            return this.mergeAttributesInto(this.properties);
        }
    }
}

