/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.jcr.resource.internal.helper.Converter;

public class BooleanConverter
implements Converter {
    private final Boolean value;

    public BooleanConverter(Boolean val) {
        this.value = val;
    }

    public String toString() {
        return this.value.toString();
    }

    private Integer getNumber() {
        return this.value != false ? 1 : 0;
    }

    public Long toLong() {
        return this.getNumber().longValue();
    }

    public Byte toByte() {
        return this.getNumber().byteValue();
    }

    public Short toShort() {
        return this.getNumber().shortValue();
    }

    public Integer toInteger() {
        return (int)this.getNumber();
    }

    public Double toDouble() {
        return this.getNumber().doubleValue();
    }

    public Float toFloat() {
        return Float.valueOf(this.getNumber().floatValue());
    }

    public Calendar toCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.toLong());
        return c;
    }

    public Date toDate() {
        return new Date(this.toLong());
    }

    public Boolean toBoolean() {
        return this.value;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.getNumber().toString());
    }
}

