/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.jcr.resource.internal.helper.Converter;

public class NumberConverter
implements Converter {
    private final Number value;

    public NumberConverter(Number val) {
        this.value = val;
    }

    public String toString() {
        return this.value.toString();
    }

    public Long toLong() {
        return this.value.longValue();
    }

    public Byte toByte() {
        return this.value.byteValue();
    }

    public Short toShort() {
        return this.value.shortValue();
    }

    public Integer toInteger() {
        return this.value.intValue();
    }

    public Double toDouble() {
        return this.value.doubleValue();
    }

    public Float toFloat() {
        return Float.valueOf(this.value.floatValue());
    }

    public Calendar toCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.toLong());
        return c;
    }

    public Date toDate() {
        return new Date(this.toLong());
    }

    public Boolean toBoolean() {
        return false;
    }

    public BigDecimal toBigDecimal() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        return new BigDecimal(this.value.toString());
    }
}

