/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.jcr.resource.internal.helper.Converter;

public class StringConverter
implements Converter {
    private final Object value;

    public StringConverter(Object val) {
        this.value = val;
    }

    public String toString() {
        return this.value.toString();
    }

    public Long toLong() {
        return Long.parseLong(this.toString());
    }

    public Byte toByte() {
        return Byte.parseByte(this.toString());
    }

    public Short toShort() {
        return Short.parseShort(this.toString());
    }

    public Integer toInteger() {
        return Integer.parseInt(this.toString());
    }

    public Double toDouble() {
        return Double.parseDouble(this.toString());
    }

    public Float toFloat() {
        return Float.valueOf(Float.parseFloat(this.toString()));
    }

    public Calendar toCalendar() {
        Calendar c = ISO8601.parse(this.toString());
        if (c == null) {
            throw new IllegalArgumentException("Not a date string: " + this.toString());
        }
        return c;
    }

    public Date toDate() {
        Calendar c = this.toCalendar();
        return c.getTime();
    }

    public Boolean toBoolean() {
        return Boolean.valueOf(this.toString());
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.toString());
    }
}

