/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.JcrModifiablePropertyMap;
import org.apache.sling.jcr.resource.JcrPropertyMap;
import org.apache.sling.jcr.resource.internal.JcrModifiableValueMap;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResourceIterator;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResourceMetadata;
import org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Adaptable(adaptableClass=Resource.class, adapters={@Adapter(value={Node.class, Map.class, Item.class, ValueMap.class}), @Adapter(value={PersistableValueMap.class}, condition="If the resource is a JcrNodeResource and the user has set property privileges on the node."), @Adapter(value={InputStream.class}, condition="If the resource is a JcrNodeResource and has a jcr:data property or is an nt:file node.")})
class JcrNodeResource
extends JcrItemResource<Node> {
    private static final String UNSET_RESOURCE_SUPER_TYPE = "<unset>";
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrNodeResource.class);
    private String resourceType;
    private String resourceSuperType;
    private final ClassLoader dynamicClassLoader;
    private final PathMapper pathMapper;

    public JcrNodeResource(ResourceResolver resourceResolver, String path, String version, Node node, ClassLoader dynamicClassLoader, PathMapper pathMapper) {
        super(resourceResolver, path, version, node, new JcrNodeResourceMetadata(node), pathMapper);
        this.pathMapper = pathMapper;
        this.dynamicClassLoader = dynamicClassLoader;
        this.resourceSuperType = UNSET_RESOURCE_SUPER_TYPE;
    }

    public String getResourceType() {
        if (this.resourceType == null) {
            try {
                this.resourceType = this.getResourceTypeForNode(this.getNode());
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to get resource type for node " + this.getNode(), (Throwable)e);
                this.resourceType = "<unknown resource type>";
            }
        }
        return this.resourceType;
    }

    public String getResourceSuperType() {
        if (this.resourceSuperType == UNSET_RESOURCE_SUPER_TYPE) {
            try {
                if (this.getNode().hasProperty("sling:resourceSuperType")) {
                    this.resourceSuperType = this.getNode().getProperty("sling:resourceSuperType").getValue().getString();
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            if (this.resourceSuperType == UNSET_RESOURCE_SUPER_TYPE) {
                this.resourceSuperType = null;
            }
        }
        return this.resourceSuperType;
    }

    public <Type> Type adaptTo(Class<Type> type) {
        if (type == Node.class || type == Item.class) {
            return (Type)this.getNode();
        }
        if (type == InputStream.class) {
            return (Type)this.getInputStream();
        }
        if (type == Map.class || type == ValueMap.class) {
            return (Type)new JcrPropertyMap(this.getNode(), this.dynamicClassLoader);
        }
        if (type == PersistableValueMap.class) {
            try {
                this.getNode().getSession().checkPermission(this.getPath(), "set_property");
                return (Type)new JcrModifiablePropertyMap(this.getNode(), this.dynamicClassLoader);
            }
            catch (AccessControlException ace) {
                LOGGER.debug("adaptTo(PersistableValueMap): Cannot set properties on {}", (Object)this);
            }
            catch (RepositoryException e) {
                LOGGER.debug("adaptTo(PersistableValueMap): Unexpected problem for {}", (Object)this);
            }
        } else if (type == ModifiableValueMap.class) {
            try {
                this.getNode().getSession().checkPermission(this.getPath(), "set_property");
                return (Type)new JcrModifiableValueMap(this.getNode(), this.dynamicClassLoader);
            }
            catch (AccessControlException ace) {
                LOGGER.debug("adaptTo(ModifiableValueMap): Cannot set properties on {}", (Object)this);
            }
            catch (RepositoryException e) {
                LOGGER.debug("adaptTo(ModifiableValueMap): Unexpected problem for {}", (Object)this);
            }
        }
        return (Type)super.adaptTo(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", type=" + this.getResourceType() + ", superType=" + this.getResourceSuperType() + ", path=" + this.getPath();
    }

    private Node getNode() {
        return (Node)this.getItem();
    }

    private InputStream getInputStream() {
        Node node = this.getNode();
        if (node != null) {
            try {
                Property data;
                Node content;
                Node node2 = content = node.isNodeType("nt:file") ? node.getNode("jcr:content") : node;
                if (content.hasProperty("jcr:data")) {
                    data = content.getProperty("jcr:data");
                } else {
                    try {
                        Item item = content.getPrimaryItem();
                        while (item.isNode()) {
                            item = ((Node)item).getPrimaryItem();
                        }
                        data = (Property)item;
                    }
                    catch (ItemNotFoundException infe) {
                        LOGGER.debug("getInputStream: No primary items for {}", (Object)this.toString(), (Object)infe);
                        data = null;
                    }
                }
                if (data != null) {
                    return data.getBinary().getStream();
                }
            }
            catch (RepositoryException re) {
                LOGGER.error("getInputStream: Cannot get InputStream for " + (Object)((Object)this), (Throwable)re);
            }
        }
        return null;
    }

    @Override
    Iterator<Resource> listJcrChildren() {
        try {
            if (this.getNode().hasNodes()) {
                return new JcrNodeResourceIterator(this.getResourceResolver(), this.path, this.version, this.getNode().getNodes(), this.dynamicClassLoader, this.pathMapper);
            }
        }
        catch (RepositoryException re) {
            LOGGER.error("listChildren: Cannot get children of " + (Object)((Object)this), (Throwable)re);
        }
        return null;
    }
}

