/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.AttributableResourceProvider;
import org.apache.sling.api.resource.DynamicResourceProvider;
import org.apache.sling.api.resource.ModifyingResourceProvider;
import org.apache.sling.api.resource.ParametrizableResourceProvider;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.QueriableResourceProvider;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.RefreshableResourceProvider;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.apache.sling.jcr.resource.internal.JcrModifiableValueMap;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResourceIterator;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrPropertyResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory;
import org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper;
import org.apache.sling.jcr.resource.internal.helper.jcr.RepositoryHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceProvider
extends SlingAdaptable
implements ResourceProvider,
DynamicResourceProvider,
AttributableResourceProvider,
QueriableResourceProvider,
RefreshableResourceProvider,
ModifyingResourceProvider,
ParametrizableResourceProvider {
    private static final String QUERY_COLUMN_PATH = "jcr:path";
    private static final String QUERY_COLUMN_SCORE = "jcr:score";
    private static final String DEFAULT_QUERY_LANGUAGE = "xpath";
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean closed = false;
    private final Session session;
    private final ClassLoader dynamicClassLoader;
    private final RepositoryHolder repositoryHolder;
    private final PathMapper pathMapper;

    public JcrResourceProvider(Session session, ClassLoader dynamicClassLoader, RepositoryHolder repositoryHolder, PathMapper pathMapper) {
        this.session = session;
        this.dynamicClassLoader = dynamicClassLoader;
        this.repositoryHolder = repositoryHolder;
        this.pathMapper = pathMapper;
    }

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) throws SlingException {
        return this.getResource(resourceResolver, path, Collections.<String, String>emptyMap());
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) throws SlingException {
        return this.getResource(resourceResolver, path, Collections.<String, String>emptyMap());
    }

    public Resource getResource(ResourceResolver resourceResolver, String path, Map<String, String> parameters) throws SlingException {
        this.checkClosed();
        try {
            return this.createResource(resourceResolver, path, parameters);
        }
        catch (RepositoryException re) {
            throw new SlingException("Problem retrieving node based resource " + path, (Throwable)re);
        }
    }

    public Iterator<Resource> listChildren(Resource parent) {
        JcrItemResource parentItemResource;
        this.checkClosed();
        if (parent instanceof JcrItemResource) {
            parentItemResource = (JcrItemResource)parent;
        } else {
            try {
                parentItemResource = this.createResource(parent.getResourceResolver(), parent.getPath(), Collections.<String, String>emptyMap());
            }
            catch (RepositoryException re) {
                parentItemResource = null;
            }
        }
        return parentItemResource != null ? parentItemResource.listJcrChildren() : null;
    }

    private JcrItemResource createResource(ResourceResolver resourceResolver, String resourcePath, Map<String, String> parameters) throws RepositoryException {
        String jcrPath = this.pathMapper.mapResourcePathToJCRPath(resourcePath);
        if (jcrPath != null && this.itemExists(jcrPath)) {
            String version;
            Item item = this.session.getItem(jcrPath);
            if (parameters != null && parameters.containsKey("v")) {
                version = parameters.get("v");
                item = this.getHistoricItem(item, version);
            } else {
                version = null;
            }
            if (item.isNode()) {
                this.log.debug("createResource: Found JCR Node Resource at path '{}'", (Object)resourcePath);
                JcrNodeResource resource = new JcrNodeResource(resourceResolver, resourcePath, version, (Node)item, this.dynamicClassLoader, this.pathMapper);
                resource.getResourceMetadata().setParameterMap(parameters);
                return resource;
            }
            this.log.debug("createResource: Found JCR Property Resource at path '{}'", (Object)resourcePath);
            JcrPropertyResource resource = new JcrPropertyResource(resourceResolver, resourcePath, version, (Property)item, this.pathMapper);
            resource.getResourceMetadata().setParameterMap(parameters);
            return resource;
        }
        this.log.debug("createResource: No JCR Item exists at path '{}'", (Object)jcrPath);
        return null;
    }

    private Item getHistoricItem(Item item, String versionSpecifier) throws RepositoryException {
        Item currentItem = item;
        LinkedList<String> relPath = new LinkedList<String>();
        Node version = null;
        while (!"/".equals(currentItem.getPath())) {
            if (JcrResourceProvider.isVersionable(currentItem)) {
                version = this.getFrozenNode((Node)currentItem, versionSpecifier);
                break;
            }
            relPath.addFirst(currentItem.getName());
            currentItem = currentItem.getParent();
        }
        if (version != null) {
            return JcrResourceProvider.getSubitem(version, StringUtils.join(relPath.iterator(), (char)'/'));
        }
        return null;
    }

    private static Item getSubitem(Node node, String relPath) throws RepositoryException {
        if (relPath.length() == 0) {
            return node;
        }
        if (node.hasNode(relPath)) {
            return node.getNode(relPath);
        }
        if (node.hasProperty(relPath)) {
            return node.getProperty(relPath);
        }
        return null;
    }

    private Node getFrozenNode(Node node, String versionSpecifier) throws RepositoryException {
        VersionManager versionManager = this.session.getWorkspace().getVersionManager();
        VersionHistory history = versionManager.getVersionHistory(node.getPath());
        if (history.hasVersionLabel(versionSpecifier)) {
            return history.getVersionByLabel(versionSpecifier).getFrozenNode();
        }
        if (history.hasNode(versionSpecifier)) {
            return history.getVersion(versionSpecifier).getFrozenNode();
        }
        return null;
    }

    private static boolean isVersionable(Item item) throws RepositoryException {
        return item.isNode() && ((Node)item).isNodeType("mix:versionable");
    }

    private boolean itemExists(String path) {
        try {
            return this.session.itemExists(path);
        }
        catch (RepositoryException re) {
            this.log.debug("itemExists: Error checking for existence of {}: {}", (Object)path, (Object)re.toString());
            return false;
        }
    }

    public boolean isLive() {
        return !this.closed && this.session.isLive();
    }

    public void close() {
        this.repositoryHolder.release();
        this.closed = true;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Resource resolver is already closed.");
        }
    }

    public Iterator<Resource> findResources(ResourceResolver resolver, String query, String language) {
        this.checkClosed();
        try {
            QueryResult res = JcrResourceUtil.query(this.session, query, language);
            return new JcrNodeResourceIterator(resolver, res.getNodes(), this.dynamicClassLoader, this.pathMapper);
        }
        catch (InvalidQueryException iqe) {
            throw new QuerySyntaxException(iqe.getMessage(), query, language, (Throwable)iqe);
        }
        catch (RepositoryException re) {
            throw new SlingException(re.getMessage(), (Throwable)re);
        }
    }

    public Iterator<ValueMap> queryResources(ResourceResolver resolver, String query, String language) {
        this.checkClosed();
        String queryLanguage = this.isSupportedQueryLanguage(language) ? language : DEFAULT_QUERY_LANGUAGE;
        try {
            QueryResult result = JcrResourceUtil.query(this.session, query, queryLanguage);
            final String[] colNames = result.getColumnNames();
            final RowIterator rows = result.getRows();
            return new Iterator<ValueMap>(){
                private ValueMap next = this.seek();

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public ValueMap next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    ValueMap result = this.next;
                    this.next = this.seek();
                    return result;
                }

                private ValueMap seek() {
                    ValueMapDecorator result = null;
                    while (result == null && rows.hasNext()) {
                        try {
                            Row jcrRow = rows.nextRow();
                            String resourcePath = JcrResourceProvider.this.pathMapper.mapJCRPathToResourcePath(jcrRow.getPath());
                            if (resourcePath == null) continue;
                            HashMap<String, Object> row = new HashMap<String, Object>();
                            boolean didPath = false;
                            boolean didScore = false;
                            Value[] values = jcrRow.getValues();
                            for (int i = 0; i < values.length; ++i) {
                                Value v = values[i];
                                if (v == null) continue;
                                String colName = colNames[i];
                                row.put(colName, JcrResourceUtil.toJavaObject(values[i]));
                                if (colName.equals(JcrResourceProvider.QUERY_COLUMN_PATH)) {
                                    didPath = true;
                                    row.put(colName, JcrResourceProvider.this.pathMapper.mapJCRPathToResourcePath(JcrResourceUtil.toJavaObject(values[i]).toString()));
                                }
                                if (!colName.equals(JcrResourceProvider.QUERY_COLUMN_SCORE)) continue;
                                didScore = true;
                            }
                            if (!didPath) {
                                row.put(JcrResourceProvider.QUERY_COLUMN_PATH, JcrResourceProvider.this.pathMapper.mapJCRPathToResourcePath(jcrRow.getPath()));
                            }
                            if (!didScore) {
                                row.put(JcrResourceProvider.QUERY_COLUMN_SCORE, jcrRow.getScore());
                            }
                            result = new ValueMapDecorator(row);
                        }
                        catch (RepositoryException re) {
                            JcrResourceProvider.this.log.error("queryResources$next: Problem accessing row values", (Throwable)re);
                        }
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }
        catch (InvalidQueryException iqe) {
            throw new QuerySyntaxException(iqe.getMessage(), query, language, (Throwable)iqe);
        }
        catch (RepositoryException re) {
            throw new SlingException(re.getMessage(), (Throwable)re);
        }
    }

    private boolean isSupportedQueryLanguage(String language) {
        try {
            String[] supportedLanguages;
            for (String lang : supportedLanguages = this.session.getWorkspace().getQueryManager().getSupportedQueryLanguages()) {
                if (!lang.equals(language)) continue;
                return true;
            }
        }
        catch (RepositoryException e) {
            this.log.error("Unable to discover supported query languages", (Throwable)e);
        }
        return false;
    }

    public Collection<String> getAttributeNames(ResourceResolver resolver) {
        String[] sessionNames;
        this.checkClosed();
        HashSet<String> names = new HashSet<String>();
        for (String name : sessionNames = this.session.getAttributeNames()) {
            if (!JcrResourceProviderFactory.isAttributeVisible(name)) continue;
            names.add(name);
        }
        return names;
    }

    public Object getAttribute(ResourceResolver resolver, String name) {
        this.checkClosed();
        if (JcrResourceProviderFactory.isAttributeVisible(name)) {
            if ("user.name".equals(name)) {
                return this.session.getUserID();
            }
            return this.session.getAttribute(name);
        }
        return null;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Session.class) {
            return (AdapterType)this.session;
        }
        if (type == Principal.class) {
            try {
                Authorizable auth;
                JackrabbitSession s;
                UserManager um;
                if (this.session instanceof JackrabbitSession && this.session.getUserID() != null && (um = (s = (JackrabbitSession)this.session).getUserManager()) != null && (auth = um.getAuthorizable(s.getUserID())) != null) {
                    return (AdapterType)auth.getPrincipal();
                }
                this.log.debug("not able to adapto Resource to Principal, let the base class try to adapt");
            }
            catch (RepositoryException e) {
                this.log.warn("error while adapting Resource to Principal, let the base class try to adapt", (Throwable)e);
            }
        }
        return (AdapterType)super.adaptTo(type);
    }

    public Resource create(ResourceResolver resolver, String resourcePath, Map<String, Object> properties) throws PersistenceException {
        String nodeType;
        Object nodeObj;
        Object object = nodeObj = properties != null ? properties.get("jcr:primaryType") : null;
        if (nodeObj != null) {
            nodeType = nodeObj.toString();
        } else {
            String resourceType;
            Object rtObj = properties != null ? properties.get("sling:resourceType") : null;
            boolean isNodeType = false;
            if (rtObj != null && (resourceType = rtObj.toString()).indexOf(58) != -1 && resourceType.indexOf(47) == -1) {
                try {
                    this.session.getWorkspace().getNodeTypeManager().getNodeType(resourceType);
                    isNodeType = true;
                }
                catch (RepositoryException ignore) {
                    // empty catch block
                }
            }
            nodeType = isNodeType ? rtObj.toString() : null;
        }
        String jcrPath = this.pathMapper.mapResourcePathToJCRPath(resourcePath);
        if (jcrPath == null) {
            throw new PersistenceException("Unable to create node at " + resourcePath, null, resourcePath, null);
        }
        Node node = null;
        try {
            int lastPos = jcrPath.lastIndexOf(47);
            Node parent = lastPos == 0 ? this.session.getRootNode() : (Node)this.session.getItem(jcrPath.substring(0, lastPos));
            String name = jcrPath.substring(lastPos + 1);
            node = nodeType != null ? parent.addNode(name, nodeType) : parent.addNode(name);
            if (properties != null) {
                JcrModifiableValueMap jcrMap = new JcrModifiableValueMap(node, this.dynamicClassLoader);
                Object value = properties.get("jcr:mixinTypes");
                if (value != null) {
                    jcrMap.put("jcr:mixinTypes", value);
                }
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    if (IGNORED_PROPERTIES.contains(entry.getKey())) continue;
                    try {
                        jcrMap.put(entry.getKey(), entry.getValue());
                    }
                    catch (IllegalArgumentException iae) {
                        try {
                            node.remove();
                        }
                        catch (RepositoryException re) {
                            // empty catch block
                        }
                        throw new PersistenceException(iae.getMessage(), (Throwable)iae, resourcePath, entry.getKey());
                    }
                }
            }
            return new JcrNodeResource(resolver, resourcePath, null, node, this.dynamicClassLoader, this.pathMapper);
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to create node at " + jcrPath, (Throwable)e, resourcePath, null);
        }
    }

    public void delete(ResourceResolver resolver, String resourcePath) throws PersistenceException {
        String jcrPath = this.pathMapper.mapResourcePathToJCRPath(resourcePath);
        if (jcrPath == null) {
            throw new PersistenceException("Unable to delete resource at " + resourcePath, null, resourcePath, null);
        }
        try {
            if (!this.session.itemExists(jcrPath)) {
                throw new PersistenceException("Unable to delete resource at " + jcrPath + ". Resource does not exist.", null, resourcePath, null);
            }
            this.session.getItem(jcrPath).remove();
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to delete resource at " + jcrPath, (Throwable)e, resourcePath, null);
        }
    }

    public void revert(ResourceResolver resolver) {
        try {
            this.session.refresh(false);
        }
        catch (RepositoryException ignore) {
            this.log.warn("Unable to revert pending changes.", (Throwable)ignore);
        }
    }

    public void commit(ResourceResolver resolver) throws PersistenceException {
        try {
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to commit changes to session.", (Throwable)e);
        }
    }

    public boolean hasChanges(ResourceResolver resolver) {
        try {
            return this.session.hasPendingChanges();
        }
        catch (RepositoryException ignore) {
            this.log.warn("Unable to check session for pending changes.", (Throwable)ignore);
            return false;
        }
    }

    public void refresh() {
        try {
            this.session.refresh(true);
        }
        catch (RepositoryException ignore) {
            this.log.warn("Unable to refresh session.", (Throwable)ignore);
        }
    }

    static {
        IGNORED_PROPERTIES.add("jcr:mixinTypes");
        IGNORED_PROPERTIES.add("jcr:primaryType");
        IGNORED_PROPERTIES.add("jcr:created");
        IGNORED_PROPERTIES.add("jcr:createdBy");
    }
}

