/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl;

import org.apache.sling.junit.SlingTestContextProvider;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestContextRunListenerWrapper
extends RunListener {
    private final RunListener wrapped;
    private long testStartTime;
    private static final Logger log = LoggerFactory.getLogger(TestContextRunListenerWrapper.class);

    TestContextRunListenerWrapper(RunListener toWrap) {
        this.wrapped = toWrap;
    }

    public void testAssumptionFailure(Failure failure) {
        this.wrapped.testAssumptionFailure(failure);
    }

    public void testFailure(Failure failure) throws Exception {
        log.warn("JUnit test execution failed: {}", (Object)failure.toString(), (Object)failure.getException());
        this.wrapped.testFailure(failure);
    }

    public void testFinished(Description description) throws Exception {
        if (SlingTestContextProvider.hasContext()) {
            SlingTestContextProvider.getContext().output().put("test_execution_time_msec", System.currentTimeMillis() - this.testStartTime);
        }
        this.wrapped.testFinished(description);
    }

    public void testIgnored(Description description) throws Exception {
        this.wrapped.testIgnored(description);
    }

    public void testRunFinished(Result result) throws Exception {
        this.wrapped.testRunFinished(result);
    }

    public void testRunStarted(Description description) throws Exception {
        this.wrapped.testRunStarted(description);
    }

    public void testStarted(Description description) throws Exception {
        this.testStartTime = System.currentTimeMillis();
        this.wrapped.testStarted(description);
    }
}

