/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Dictionary;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.jacoco.agent.rt.IAgent;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true)
public class JacocoServlet
extends HttpServlet {
    private static final String PARAM_SESSION_ID = ":sessionId";
    private static final String JMX_NAME = "org.jacoco:type=Runtime";
    public static final String EXPLAIN = "This servlet exposes JaCoCo (http://www.eclemma.org/jacoco) code coverage data to HTTP clients by calling JaCoCo's IAgent.getExecutionData(...).\n\nPOST requests reset the agent after returning the execution data, whereas GET requests just return the data.\nJaCoCo's session ID can be set via a :sessionId request parameter.\nThe servlet returns 404 if the IAgent MBean is not available.\n\nPlease keep the JaCoCo security considerations in mind before enabling its agent: JaCoCo's tcpserver and tcpclient modes and its JMX interface open ports that do not require any authentication. See the JaCoCo documentation for details.\n\nTo activate JaCoCo on a Sling instance, start its JVM with the following option:\n\n-javaagent:/path/to/jacocoagent.jar=dumponexit=false,jmx=true\n\nThe jacocoagent.jar file can be extracted from the appropriate maven artifact into the target directory using 'mvn process-sources -P extractJacocoAgent' if you have this module's source code.\n\nWith this servlet installed, you can generate a JaCoCo coverage report as follows (for example), from a folder that contains a pom.xml:\n\n  curl -o target/jacoco.exec http://localhost:8080/system/sling/jacoco/exec\n  mvn org.jacoco:jacoco-maven-plugin:report\n  open target/site/jacoco/index.html\n\n";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Property(value={"/system/sling/jacoco"})
    static final String SERVLET_PATH_NAME = "servlet.path";
    public static final String EXEC_PATH = "/exec";
    private String servletPath;
    @Reference
    private HttpService httpService;

    protected void activate(ComponentContext ctx) throws ServletException, NamespaceException {
        this.servletPath = this.getServletPath(ctx);
        if (this.servletPath == null) {
            this.log.info("Servlet path is null, not registering with HttpService");
        } else {
            this.httpService.registerServlet(this.servletPath, (Servlet)this, null, null);
            this.log.info("Servlet registered at {}", (Object)this.servletPath);
        }
    }

    protected String getServletPath(ComponentContext ctx) {
        Dictionary config = ctx.getProperties();
        String result = (String)config.get(SERVLET_PATH_NAME);
        if (result != null && result.trim().length() == 0) {
            result = null;
        }
        return result;
    }

    protected void deactivate(ComponentContext ctx) throws ServletException, NamespaceException {
        if (this.servletPath != null) {
            this.httpService.unregister(this.servletPath);
            this.log.info("Servlet unregistered from path {}", (Object)this.servletPath);
        }
        this.servletPath = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (EXEC_PATH.equals(req.getPathInfo())) {
            IAgent agent = this.getAgent();
            if (agent == null) {
                String msg = "The Jacoco agent MBean is not available\n\n";
                resp.sendError(404, "The Jacoco agent MBean is not available\n\n" + this.getUsageInfo());
            } else {
                this.sendJacocoData(req, resp, false);
                resp.setContentType("application/octet-stream");
            }
        } else {
            resp.setContentType("text/plain");
            resp.setCharacterEncoding("UTF-8");
            resp.getWriter().write(this.getUsageInfo());
            resp.getWriter().flush();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.sendJacocoData(req, resp, true);
    }

    private void sendJacocoData(HttpServletRequest req, HttpServletResponse resp, boolean resetAgent) throws IOException {
        IAgent agent = this.getAgent();
        if (agent == null) {
            String msg = "The Jacoco agent MBean is not available\n\n";
            resp.sendError(404, "The Jacoco agent MBean is not available\n\n" + this.getUsageInfo());
        } else {
            resp.setContentType("application/octet-stream");
            String sessionId = req.getParameter(PARAM_SESSION_ID);
            this.log.info("Getting JaCoCo execution data, resetAgent={}", (Object)resetAgent);
            byte[] data = agent.getExecutionData(resetAgent);
            if (sessionId != null) {
                this.log.info("Setting JaCoCo sessionId={}", (Object)sessionId);
                agent.setSessionId(sessionId);
            }
            resp.getOutputStream().write(data);
            resp.getOutputStream().flush();
        }
    }

    private String getUsageInfo() {
        return "This is " + ((Object)((Object)this)).getClass().getName() + "\n\n" + ("To get the jacoco data, use " + this.servletPath + EXEC_PATH) + "\n\n" + EXPLAIN;
    }

    private IAgent getAgent() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName(JMX_NAME);
            if (mbs.isRegistered(name)) {
                return MBeanServerInvocationHandler.newProxyInstance(mbs, name, IAgent.class, false);
            }
        }
        catch (MalformedObjectNameException e) {
            this.log.error("[getAgent] there is a typo in the JMX_NAME constant", (Throwable)e);
        }
        return null;
    }

    protected void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unbindHttpService(HttpService httpService) {
        if (this.httpService == httpService) {
            this.httpService = null;
        }
    }
}

