/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.RendererFactory;
import org.apache.sling.junit.SlingTestContextProvider;
import org.apache.sling.junit.TestSelector;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=false)
@Service
public class JsonRenderer
extends RunListener
implements Renderer,
RendererFactory {
    public static final String EXTENSION = "json";
    public static final String INFO_TYPE_KEY = "INFO_TYPE";
    public static final String INFO_SUBTYPE_KEY = "INFO_SUBTYPE";
    public static final String TEST_METADATA = "test_metadata";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JSONWriter writer;

    @Override
    public Renderer createRenderer() {
        return new JsonRenderer();
    }

    @Override
    public boolean appliesTo(TestSelector selector) {
        return EXTENSION.equals(selector.getExtension());
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public void setup(HttpServletResponse response, String pageTitle) throws IOException, UnsupportedEncodingException {
        if (this.writer != null) {
            throw new IllegalStateException("Output Writer already set");
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        this.writer = new JSONWriter((Writer)response.getWriter());
        this.writer.setTidy(true);
        try {
            this.writer.array();
        }
        catch (JSONException jex) {
            throw (IOException)new IOException().initCause(jex);
        }
    }

    @Override
    public void cleanup() {
        if (this.writer != null) {
            try {
                this.writer.endArray();
            }
            catch (JSONException jex) {
                this.log.warn("JSONException in cleanup()", (Throwable)jex);
            }
        }
        this.writer = null;
    }

    @Override
    public void info(String cssClass, String info) {
        try {
            this.startItem("info");
            this.writer.key(INFO_SUBTYPE_KEY).value((Object)cssClass);
            this.writer.key("info").value((Object)info);
            this.endItem();
        }
        catch (JSONException jex) {
            this.log.warn("JSONException in info()", (Throwable)jex);
        }
    }

    @Override
    public void list(String cssClass, Collection<String> data) {
        try {
            this.startItem("list");
            this.writer.key(INFO_SUBTYPE_KEY).value((Object)cssClass);
            this.writer.key("data");
            this.writer.array();
            for (String str : data) {
                this.writer.value((Object)str);
            }
            this.writer.endArray();
            this.endItem();
        }
        catch (JSONException jex) {
            this.log.warn("JSONException in list()", (Throwable)jex);
        }
    }

    @Override
    public void title(int level, String title) {
    }

    @Override
    public void link(String info, String url, String method) {
        try {
            this.startItem("link");
            this.writer.key("info").value((Object)info);
            this.writer.key("method").value((Object)method);
            this.writer.key("url").value((Object)url);
            this.endItem();
        }
        catch (JSONException jex) {
            this.log.warn("JSONException in link()", (Throwable)jex);
        }
    }

    @Override
    public RunListener getRunListener() {
        return this;
    }

    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
        this.startItem("test");
        this.writer.key("description").value((Object)description.toString());
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        if (SlingTestContextProvider.hasContext()) {
            this.outputContextMap(SlingTestContextProvider.getContext().output());
        }
        this.endItem();
    }

    public void testFailure(Failure failure) throws Exception {
        this.writer.key("failure").value((Object)failure.toString());
        this.writer.key("trace").value((Object)failure.getTrace());
    }

    public void testRunFinished(Result result) throws Exception {
    }

    void startItem(String name) throws JSONException {
        this.writer.object();
        this.writer.key(INFO_TYPE_KEY).value((Object)name);
    }

    void endItem() throws JSONException {
        this.writer.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void outputContextMap(Map<String, Object> data) throws JSONException {
        this.writer.key(TEST_METADATA);
        this.writer.object();
        try {
            for (Map.Entry<String, Object> e : data.entrySet()) {
                this.writer.key(e.getKey());
                this.writer.value(e.getValue());
            }
        }
        finally {
            this.writer.endObject();
        }
    }
}

