/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.RendererSelector;
import org.apache.sling.junit.RequestParser;
import org.apache.sling.junit.TestSelector;
import org.apache.sling.junit.TestsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String CSS = "junit.css";
    public static final String FORCE_RELOAD_PARAM = "forceReload";
    private final TestsManager testsManager;
    private final RendererSelector rendererSelector;

    public ServletProcessor(TestsManager testsManager, RendererSelector rendererSelector) {
        this.testsManager = testsManager;
        this.rendererSelector = rendererSelector;
    }

    private List<String> getTestNames(TestSelector selector, boolean forceReload) {
        LinkedList<String> result = new LinkedList<String>();
        if (forceReload) {
            this.log.debug("{} is true, clearing TestsManager caches", (Object)FORCE_RELOAD_PARAM);
        }
        result.addAll(this.testsManager.getTestNames(selector));
        Collections.sort(result);
        return result;
    }

    private void sendCss(HttpServletResponse response) throws IOException {
        InputStream str = this.getClass().getResourceAsStream("/junit.css");
        if (str == null) {
            response.sendError(404, CSS);
        } else {
            response.setContentType("text/css");
            ServletOutputStream out = response.getOutputStream();
            byte[] buffer = new byte[16384];
            int count = 0;
            while ((count = str.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
            out.flush();
        }
    }

    private boolean getForceReloadOption(HttpServletRequest request) {
        boolean forceReload = "true".equalsIgnoreCase(request.getParameter(FORCE_RELOAD_PARAM));
        this.log.debug("{} option is set to {}", (Object)FORCE_RELOAD_PARAM, (Object)forceReload);
        return forceReload;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response, String servletPath) throws ServletException, IOException {
        boolean forceReload = this.getForceReloadOption(request);
        String pi = request.getPathInfo();
        if (pi == null) {
            response.sendRedirect(request.getContextPath() + servletPath + "/");
        } else if (pi.endsWith(CSS)) {
            this.sendCss(response);
            return;
        }
        TestSelector selector = this.getTestSelector(request);
        List<String> testNames = this.getTestNames(selector, forceReload);
        if (testNames.isEmpty()) {
            String msg = "WARNING: no test classes found for selector " + selector + ", check the requirements of the active " + "TestsProvider services for how to supply tests.";
            response.sendError(404, msg);
            return;
        }
        Renderer renderer = this.rendererSelector.getRenderer(selector);
        if (renderer == null) {
            throw new ServletException("No Renderer found for " + selector);
        }
        this.log.debug("GET request: {}", (Object)selector);
        renderer.setup(response, this.getClass().getSimpleName());
        renderer.info("info", "Test selector: " + selector);
        try {
            this.testsManager.listTests(testNames, renderer);
            String postPath = this.getTestExecutionPath(request, selector, renderer.getExtension());
            renderer.link("Execute these tests", postPath, "POST");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        renderer.cleanup();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TestSelector selector = this.getTestSelector(request);
        boolean forceReload = this.getForceReloadOption(request);
        this.log.info("POST request, executing tests: {}, {}={}", new Object[]{selector, FORCE_RELOAD_PARAM, forceReload});
        Renderer renderer = this.rendererSelector.getRenderer(selector);
        if (renderer == null) {
            throw new ServletException("No Renderer found for " + selector);
        }
        renderer.setup(response, this.getClass().getSimpleName());
        List<String> testNames = this.getTestNames(selector, forceReload);
        if (testNames.isEmpty()) {
            response.sendError(404, "No tests found for " + selector);
        }
        try {
            this.testsManager.executeTests(testNames, renderer, selector);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        renderer.cleanup();
    }

    private TestSelector getTestSelector(HttpServletRequest request) {
        return new RequestParser(this.getTestSelectionPath(request));
    }

    protected String getTestSelectionPath(HttpServletRequest request) {
        return request.getPathInfo();
    }

    protected String getTestExecutionPath(HttpServletRequest request, TestSelector selector, String extension) {
        String selectedTestMethodName = selector.getSelectedTestMethodName();
        String methodStr = "";
        if (selectedTestMethodName != null && !"".equals(selectedTestMethodName)) {
            methodStr = "/" + selectedTestMethodName;
        }
        return "./" + selector.getTestSelectorString() + methodStr + "." + extension;
    }
}

