/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.junit.RendererSelector;
import org.apache.sling.junit.TestSelector;
import org.apache.sling.junit.TestsManager;
import org.apache.sling.junit.impl.servlet.ServletProcessor;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.NamespaceException;

@Component(metatype=true)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/junit/testing"}), @Property(name="sling.servlet.extensions", value={"junit"}), @Property(name="sling.servlet.methods", value={"GET", "POST"})})
public class SlingJUnitServlet
extends HttpServlet {
    public static final String EXTENSION = ".junit";
    @Reference
    private TestsManager testsManager;
    @Reference
    private RendererSelector rendererSelector;
    private volatile ServletProcessor processor;

    protected void activate(ComponentContext ctx) throws ServletException, NamespaceException {
        this.processor = new ServletProcessor(this.testsManager, this.rendererSelector){

            @Override
            protected String getTestSelectionPath(HttpServletRequest request) {
                String result = request.getPathInfo();
                int pos = result.indexOf(SlingJUnitServlet.EXTENSION);
                if (pos >= 0) {
                    result = result.substring(pos + SlingJUnitServlet.EXTENSION.length());
                }
                return result;
            }

            @Override
            protected String getTestExecutionPath(HttpServletRequest request, TestSelector selector, String extension) {
                String selectedTestMethodName = selector.getSelectedTestMethodName();
                String methodStr = "";
                if (selectedTestMethodName != null && !"".equals(selectedTestMethodName)) {
                    methodStr = "/" + selectedTestMethodName;
                }
                return "./" + selector.getTestSelectorString() + methodStr + "." + extension;
            }
        };
    }

    protected void deactivate(ComponentContext ctx) throws ServletException, NamespaceException {
        this.processor = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processor.doGet(req, resp, null);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processor.doPost(req, resp);
    }

    protected void bindTestsManager(TestsManager testsManager) {
        this.testsManager = testsManager;
    }

    protected void unbindTestsManager(TestsManager testsManager) {
        if (this.testsManager == testsManager) {
            this.testsManager = null;
        }
    }

    protected void bindRendererSelector(RendererSelector rendererSelector) {
        this.rendererSelector = rendererSelector;
    }

    protected void unbindRendererSelector(RendererSelector rendererSelector) {
        if (this.rendererSelector == rendererSelector) {
            this.rendererSelector = null;
        }
    }
}

