/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.junit.Activator;
import org.apache.sling.junit.rules.ServiceGetter;
import org.apache.sling.junit.rules.TeleporterRule;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class ServerSideTeleporter
extends TeleporterRule {
    private final List<ServiceReference> toUnget = new ArrayList<ServiceReference>();
    private final BundleContext bundleContext = Activator.getBundleContext();

    ServerSideTeleporter() {
        if (this.bundleContext == null) {
            throw new IllegalStateException("Null BundleContext, should not happen when this class is used");
        }
    }

    protected void after() {
        super.after();
        for (ServiceReference r : this.toUnget) {
            if (r == null) continue;
            this.bundleContext.ungetService(r);
        }
    }

    @Override
    public <T> T getService(Class<T> serviceClass, String ldapFilter) {
        ServiceGetter sg = new ServiceGetter(this.bundleContext, serviceClass, ldapFilter);
        this.toUnget.add(sg.serviceReference);
        return serviceClass.cast(sg.service);
    }
}

