/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.rules;

import org.apache.sling.junit.Activator;
import org.apache.sling.junit.rules.ServiceGetter;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.framework.BundleContext;

public class Service
implements TestRule {
    private final Class<?> serviceClass;
    private Object service;

    public Service(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                BundleContext bundleContext = Activator.getBundleContext();
                if (bundleContext == null) {
                    base.evaluate();
                    return;
                }
                ServiceGetter sg = new ServiceGetter(bundleContext, Service.this.serviceClass, null);
                Service.this.service = Service.this.serviceClass.cast(sg.service);
                try {
                    base.evaluate();
                }
                finally {
                    Service.this.service = null;
                    if (sg.serviceReference != null) {
                        bundleContext.ungetService(sg.serviceReference);
                    }
                }
            }
        };
    }

    public <T> T getService(Class<T> serviceClass) {
        return serviceClass.cast(this.service);
    }
}

