/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class ServiceGetter {
    final ServiceReference serviceReference;
    final Object service;

    ServiceGetter(BundleContext bundleContext, Class<?> serviceClass, String ldapFilter) {
        Object s;
        if (serviceClass.equals(BundleContext.class)) {
            s = serviceClass.cast(bundleContext);
            this.serviceReference = null;
        } else {
            if (ldapFilter != null && !ldapFilter.isEmpty()) {
                try {
                    ServiceReference[] services = bundleContext.getServiceReferences(serviceClass.getName(), ldapFilter);
                    if (services == null) {
                        this.serviceReference = null;
                    }
                    List<ServiceReference> sorted = Arrays.asList(services);
                    Collections.sort(sorted);
                    this.serviceReference = sorted.get(sorted.size() - 1);
                }
                catch (InvalidSyntaxException e) {
                    throw new IllegalStateException("Invalid filter syntax:" + ldapFilter, e);
                }
            } else {
                this.serviceReference = bundleContext.getServiceReference(serviceClass.getName());
            }
            if (this.serviceReference == null) {
                throw new IllegalStateException("unable to get a service reference, class=" + serviceClass.getName() + ", filter='" + ldapFilter + "'");
            }
            Object service = bundleContext.getService(this.serviceReference);
            if (service == null) {
                throw new IllegalStateException("unable to get an instance of the service");
            }
            s = serviceClass.cast(service);
        }
        this.service = s;
    }
}

