/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.osgi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortingServiceTracker<T>
extends ServiceTracker {
    private int lastCount = -1;
    private int lastRefCount = -1;
    private List<T> sortedServiceCache;
    private List<ServiceReference> sortedReferences;

    public SortingServiceTracker(BundleContext context, String clazz) {
        super(context, clazz, null);
    }

    @Override
    public void removedService(ServiceReference reference, Object service) {
        this.sortedServiceCache = null;
        this.sortedReferences = null;
        this.context.ungetService(reference);
    }

    @Override
    public void modifiedService(ServiceReference reference, Object service) {
        this.sortedServiceCache = null;
        this.sortedReferences = null;
    }

    @Override
    public Object addingService(ServiceReference reference) {
        this.sortedServiceCache = null;
        this.sortedReferences = null;
        return this.context.getService(reference);
    }

    public List<T> getSortedServices() {
        List<T> result = this.sortedServiceCache;
        if (result == null || this.lastCount < this.getTrackingCount()) {
            this.lastCount = this.getTrackingCount();
            Object[] references = this.getServiceReferences();
            if (references == null || references.length == 0) {
                result = Collections.emptyList();
            } else {
                Arrays.sort(references);
                result = new ArrayList<T>();
                for (int i = 0; i < references.length; ++i) {
                    Object service = this.getService((ServiceReference)references[references.length - 1 - i]);
                    if (service == null) continue;
                    result.add(service);
                }
            }
            this.sortedServiceCache = result;
        }
        return result;
    }

    public List<ServiceReference> getSortedServiceReferences() {
        List<Object> result = this.sortedReferences;
        if (result == null || this.lastRefCount < this.getTrackingCount()) {
            this.lastRefCount = this.getTrackingCount();
            Object[] references = this.getServiceReferences();
            if (references == null || references.length == 0) {
                result = Collections.emptyList();
            } else {
                Arrays.sort(references);
                result = new ArrayList<ServiceReference>();
                for (int i = 0; i < references.length; ++i) {
                    result.add((ServiceReference)references[references.length - 1 - i]);
                }
            }
            this.sortedReferences = result;
        }
        return result;
    }
}

