/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.io.PrintWriter;
import java.util.Collection;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory2;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;

public class ModelConfigurationPrinter {
    private final ModelAdapterFactory modelAdapterFactory;

    ModelConfigurationPrinter(ModelAdapterFactory modelAdapterFactory) {
        this.modelAdapterFactory = modelAdapterFactory;
    }

    public void printConfiguration(PrintWriter printWriter) {
        printWriter.println("Sling Models Injectors:");
        Collection<Injector> injectors = this.modelAdapterFactory.getInjectors();
        if (injectors.isEmpty()) {
            printWriter.println("none");
        } else {
            for (Injector injector : injectors) {
                printWriter.printf("%s - %s", injector.getName(), injector.getClass().getName());
                printWriter.println();
            }
        }
        printWriter.println();
        printWriter.println("Sling Models Inject Annotation Processor Factories:");
        Collection<InjectAnnotationProcessorFactory> factories = this.modelAdapterFactory.getInjectAnnotationProcessorFactories();
        Collection<InjectAnnotationProcessorFactory2> factories2 = this.modelAdapterFactory.getInjectAnnotationProcessorFactories2();
        Collection<StaticInjectAnnotationProcessorFactory> staticFactories = this.modelAdapterFactory.getStaticInjectAnnotationProcessorFactories();
        if (factories.isEmpty() && factories2.isEmpty() && staticFactories.isEmpty()) {
            printWriter.println("none");
        } else {
            for (StaticInjectAnnotationProcessorFactory staticInjectAnnotationProcessorFactory : staticFactories) {
                printWriter.printf("%s", staticInjectAnnotationProcessorFactory.getClass().getName());
                printWriter.println();
            }
            for (InjectAnnotationProcessorFactory2 injectAnnotationProcessorFactory2 : factories2) {
                printWriter.printf("%s", injectAnnotationProcessorFactory2.getClass().getName());
                printWriter.println();
            }
            for (InjectAnnotationProcessorFactory injectAnnotationProcessorFactory : factories) {
                printWriter.printf("%s", injectAnnotationProcessorFactory.getClass().getName());
                printWriter.println();
            }
        }
        printWriter.println();
        printWriter.println("Sling Models Implementation Pickers:");
        ImplementationPicker[] pickers = this.modelAdapterFactory.getImplementationPickers();
        if (pickers == null || pickers.length == 0) {
            printWriter.println("none");
        } else {
            for (ImplementationPicker picker : pickers) {
                printWriter.printf("%s", picker.getClass().getName());
                printWriter.println();
            }
        }
    }
}

