/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourcemerger.impl.CRUDMergingResourceProvider;
import org.apache.sling.resourcemerger.impl.MergingResourceProvider;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker2;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class MergedResourcePickerWhiteboard {
    private BundleContext bundleContext;
    private final Map<Long, ServiceRegistration<ResourceProvider<Void>>> resourceProvidersPerPickerServiceId = new ConcurrentHashMap<Long, ServiceRegistration<ResourceProvider<Void>>>();

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<ResourceProvider<Void>> resourceProvider : this.resourceProvidersPerPickerServiceId.values()) {
            resourceProvider.unregister();
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    public void bindMergedResourcePicker(MergedResourcePicker resourcePicker, Map<String, Object> properties) {
        this.registerMergingResourceProvider((resolver, relativePath, relatedResource) -> resourcePicker.pickResources(resolver, relativePath), properties);
    }

    public void unbindMergedResourcePicker(Map<String, Object> properties) {
        this.unregisterMergingResourceProvider(properties);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    public void bindMergedResourcePicker2(MergedResourcePicker2 resourcePicker, Map<String, Object> properties) {
        this.registerMergingResourceProvider(resourcePicker, properties);
    }

    public void unbindMergedResourcePicker2(Map<String, Object> properties) {
        this.unregisterMergingResourceProvider(properties);
    }

    private void registerMergingResourceProvider(MergedResourcePicker2 resourcePicker, Map<String, Object> properties) {
        String mergeRoot = properties.getOrDefault("merge.root", null);
        if (mergeRoot != null) {
            boolean readOnly = PropertiesUtil.toBoolean((Object)properties.get("merge.readOnly"), (boolean)true);
            boolean traverseParent = PropertiesUtil.toBoolean((Object)properties.get("merge.traverseParent"), (boolean)false);
            MergingResourceProvider provider = readOnly ? new MergingResourceProvider(mergeRoot, resourcePicker, true, traverseParent) : new CRUDMergingResourceProvider(mergeRoot, resourcePicker, traverseParent);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("provider.name", readOnly ? "Merging" : "CRUDMerging");
            ((Dictionary)props).put("provider.root", mergeRoot);
            ((Dictionary)props).put("provider.modifiable", !readOnly);
            ((Dictionary)props).put("provider.authenticate", "no");
            Long key = (Long)properties.get("service.id");
            ServiceRegistration resourceProvider = this.bundleContext.registerService(ResourceProvider.class.getName(), (Object)provider, props);
            this.resourceProvidersPerPickerServiceId.put(key, (ServiceRegistration<ResourceProvider<Void>>)resourceProvider);
        }
    }

    private void unregisterMergingResourceProvider(Map<String, Object> properties) {
        ServiceRegistration<ResourceProvider<Void>> resourceProvider;
        Long key = (Long)properties.get("service.id");
        if (key != null && (resourceProvider = this.resourceProvidersPerPickerServiceId.get(key)) != null) {
            resourceProvider.unregister();
        }
    }
}

