/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryPreconditions {
    private final List<Map<String, Object>> earlyPropertiesList = new ArrayList<Map<String, Object>>();
    private volatile List<RequiredProvider> requiredProviders;
    private Boolean cachedResult = Boolean.FALSE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(BundleContext bc, String[] configuration) {
        ArrayList<RequiredProvider> rps = new ArrayList<RequiredProvider>();
        if (configuration != null) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            for (String r : configuration) {
                if (r == null || r.trim().length() <= 0) continue;
                String value = r.trim();
                RequiredProvider rp = new RequiredProvider();
                if (value.startsWith("(")) {
                    try {
                        rp.filter = bc.createFilter(value);
                    }
                    catch (InvalidSyntaxException e) {
                        logger.warn("Ignoring invalid filter syntax for required provider: " + value, (Throwable)e);
                        rp = null;
                    }
                } else {
                    rp.pid = value;
                }
                if (rp == null) continue;
                rps.add(rp);
            }
        }
        FactoryPreconditions factoryPreconditions = this;
        synchronized (factoryPreconditions) {
            this.requiredProviders = rps;
            this.cachedResult = null;
            for (Map<String, Object> props : this.earlyPropertiesList) {
                this.bindProvider(props);
            }
            this.earlyPropertiesList.clear();
        }
    }

    public void deactivate() {
        this.requiredProviders = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPreconditions() {
        FactoryPreconditions factoryPreconditions = this;
        synchronized (factoryPreconditions) {
            if (this.cachedResult != null) {
                return this.cachedResult;
            }
            boolean canRegister = false;
            if (this.requiredProviders != null) {
                canRegister = true;
                for (RequiredProvider rp : this.requiredProviders) {
                    if (rp.matchingServices.size() != 0) continue;
                    canRegister = false;
                    break;
                }
            }
            this.cachedResult = canRegister;
            return canRegister;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindProvider(Map<String, Object> props) {
        FactoryPreconditions factoryPreconditions = this;
        synchronized (factoryPreconditions) {
            if (this.requiredProviders == null) {
                this.earlyPropertiesList.add(props);
                return;
            }
            Hashtable<String, Object> dict = null;
            for (RequiredProvider rp : this.requiredProviders) {
                if (rp.pid != null) {
                    if (!rp.pid.equals(props.get("service.pid"))) continue;
                    rp.matchingServices.add(props);
                    this.cachedResult = null;
                    continue;
                }
                if (dict == null) {
                    dict = new Hashtable<String, Object>(props);
                }
                if (!rp.filter.match(dict)) continue;
                rp.matchingServices.add(props);
                this.cachedResult = null;
            }
        }
    }

    private boolean removeFromList(List<Map<String, Object>> list, Map<String, Object> props) {
        Long id = (Long)props.get("service.id");
        for (int index = 0; index < list.size(); ++index) {
            Long currentId = (Long)list.get(index).get("service.id");
            if (currentId != id) continue;
            list.remove(index);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindProvider(Map<String, Object> props) {
        FactoryPreconditions factoryPreconditions = this;
        synchronized (factoryPreconditions) {
            if (this.requiredProviders == null) {
                this.removeFromList(this.earlyPropertiesList, props);
                return;
            }
            for (RequiredProvider rp : this.requiredProviders) {
                if (!this.removeFromList(rp.matchingServices, props)) continue;
                this.cachedResult = null;
            }
        }
    }

    private static final class RequiredProvider {
        public String pid;
        public Filter filter;
        public final List<Map<String, Object>> matchingServices = new ArrayList<Map<String, Object>>();

        private RequiredProvider() {
        }
    }
}

