/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

public class BloomFilterUtils {
    private static final int MUL = 2153;
    private static final int SHIFT = 19;
    private static final double BIT_FACTOR = -Math.log(0.02) / Math.pow(Math.log(2.0), 2.0);

    public static byte[] createFilter(int elementCount, int maxBytes) {
        int bits = (int)((double)elementCount * BIT_FACTOR) + 7;
        return new byte[Math.min(maxBytes, bits / 8)];
    }

    public static void add(byte[] bloom, Object key) {
        int len = bloom.length;
        if (len > 0) {
            int h1 = BloomFilterUtils.hash(key.hashCode());
            int h2 = BloomFilterUtils.hash(h1);
            int n = (h1 >>> 3) % len;
            bloom[n] = (byte)(bloom[n] | 1 << (h1 & 7));
            int n2 = (h2 >>> 3) % len;
            bloom[n2] = (byte)(bloom[n2] | 1 << (h2 & 7));
        }
    }

    public static void remove(byte[] bloom, Object key) {
        throw new UnsupportedOperationException();
    }

    public static boolean probablyContains(byte[] bloom, Object key) {
        int len = bloom.length;
        if (len == 0) {
            return true;
        }
        int h1 = BloomFilterUtils.hash(key.hashCode());
        long x = bloom[(h1 >>> 3) % len] & 1 << (h1 & 7);
        if (x != 0L) {
            int h2 = BloomFilterUtils.hash(h1);
            x = bloom[(h2 >>> 3) % len] & 1 << (h2 & 7);
        }
        return x != 0L;
    }

    private static int hash(int key) {
        int hash = key;
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = hash >>> 16 ^ hash;
        return hash;
    }
}

