/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.tree;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.sling.api.resource.ParametrizableResourceProvider;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.resourceresolver.impl.tree.ProviderHandler;

public class ResourceProviderHandler
extends ProviderHandler {
    private final ResourceProvider resourceProvider;

    public ResourceProviderHandler(ResourceProvider resourceProvider, Map<String, Object> properties) {
        super(properties);
        this.resourceProvider = resourceProvider;
    }

    @Override
    public Resource getResource(ResourceResolverContext ctx, ResourceResolver resourceResolver, String path, Map<String, String> parameters) {
        Resource resource = MapUtils.isNotEmpty(parameters) && this.resourceProvider instanceof ParametrizableResourceProvider ? ((ParametrizableResourceProvider)this.resourceProvider).getResource(resourceResolver, path, parameters) : this.resourceProvider.getResource(resourceResolver, path);
        return this.getReadableResource(ctx, resource);
    }

    @Override
    public Iterator<Resource> listChildren(ResourceResolverContext ctx, Resource parent) {
        return this.getReadableChildrenIterator(ctx, this.resourceProvider.listChildren(parent));
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public ResourceProvider getResourceProvider(ResourceResolverContext ctx) {
        return this.getResourceProvider();
    }

    public int hashCode() {
        return this.resourceProvider.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceProviderHandler) {
            return this.resourceProvider.equals(((ResourceProviderHandler)obj).resourceProvider);
        }
        if (obj instanceof ResourceProvider) {
            return this.resourceProvider.equals(obj);
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.resourceProvider.toString();
    }
}

