/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service {
    private static final String PREFIX = "META-INF/services/";

    public static <ProviderType> Iterator<ProviderType> providers(Class<ProviderType> type, ClassLoader loader) throws IOException {
        if (loader != null) {
            try {
                String name = PREFIX + type.getName();
                Enumeration<URL> files = loader.getResources(name);
                return new NameIterator(loader, files);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList().iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameIterator<ProviderType>
    implements Iterator<ProviderType> {
        private final ClassLoader loader;
        private final Enumeration<?> files;
        private Iterator<String> currentFile;
        private ProviderType nextProvider;

        public NameIterator(ClassLoader loader, Enumeration<?> files) {
            this.loader = loader;
            this.files = files;
            this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.nextProvider != null;
        }

        @Override
        public ProviderType next() {
            if (this.nextProvider == null) {
                throw new NoSuchElementException();
            }
            ProviderType result = this.nextProvider;
            this.seek();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void seek() {
            if (this.currentFile == null || !this.currentFile.hasNext()) {
                this.currentFile = this.getNames();
            }
            this.nextProvider = this.getClass(this.currentFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterator<String> getNames() {
            while (this.files.hasMoreElements()) {
                URL fileUrl = (URL)this.files.nextElement();
                InputStream ins = null;
                try {
                    String name;
                    ArrayList<String> names = new ArrayList<String>();
                    ins = fileUrl.openStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(ins));
                    while ((name = br.readLine()) != null) {
                        int hash = name.indexOf(35);
                        if (hash >= 0) {
                            name = name.substring(0, hash);
                        }
                        if ((name = name.trim()).length() <= 0) continue;
                        names.add(name);
                    }
                    Iterator<String> iterator = names.iterator();
                    return iterator;
                }
                catch (IOException ioe) {}
                continue;
                finally {
                    if (ins == null) continue;
                    try {
                        ins.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            return null;
        }

        private ProviderType getClass(Iterator<String> currentFile) {
            if (currentFile != null && currentFile.hasNext()) {
                String name = currentFile.next();
                try {
                    Class<?> clazz = Class.forName(name, true, this.loader);
                    return (ProviderType)clazz.newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

