/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;

public class ScriptEngineManager {
    private final Map<String, ScriptEngineFactory> registeredByName = new HashMap<String, ScriptEngineFactory>();
    private final Map<String, ScriptEngineFactory> registeredByExtension = new HashMap<String, ScriptEngineFactory>();
    private final Map<String, ScriptEngineFactory> registeredByMimeType = new HashMap<String, ScriptEngineFactory>();
    private Bindings globalScope = new SimpleBindings();

    public ScriptEngineManager() {
    }

    public ScriptEngineManager(ClassLoader classLoader) {
        this();
    }

    public Bindings getBindings() {
        return this.globalScope;
    }

    public void setBindings(Bindings globalScope) {
        if (globalScope == null) {
            throw new IllegalArgumentException("Global scope cannot be null.");
        }
        this.globalScope = globalScope;
    }

    @Deprecated
    public Bindings getGlobalScope() {
        return this.getBindings();
    }

    @Deprecated
    public void setGlobalScope(Bindings globalScope) {
        this.setBindings(globalScope);
    }

    public void put(String key, Object value) {
        this.globalScope.put(key, value);
    }

    public Object get(String key) {
        return this.globalScope.get(key);
    }

    public ScriptEngine getEngineByName(String shortName) {
        ScriptEngineFactory factory = this.registeredByName.get(shortName);
        if (factory == null) {
            return null;
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.setBindings(this.globalScope, 200);
        return engine;
    }

    public ScriptEngine getEngineByExtension(String extension) {
        ScriptEngineFactory factory = this.registeredByExtension.get(extension);
        if (factory == null) {
            return null;
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.setBindings(this.globalScope, 200);
        return engine;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        ScriptEngineFactory factory = this.registeredByMimeType.get(mimeType);
        if (factory == null) {
            return null;
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.setBindings(this.globalScope, 200);
        return engine;
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        return Collections.emptyList();
    }

    public void registerEngineName(String name, ScriptEngineFactory factory) {
        this.registeredByName.put(name, factory);
    }

    public void registerEngineMimeType(String type, ScriptEngineFactory factory) {
        this.registeredByMimeType.put(type, factory);
    }

    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        this.registeredByExtension.put(extension, factory);
    }
}

