/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.scripting.jsp.jasper.IOProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SlingIOProvider
implements IOProvider {
    private static final String WEB_INF_TAGS = "/WEB-INF/tags";
    private final Logger log = LoggerFactory.getLogger(SlingIOProvider.class);
    private final ThreadLocal<ResourceResolver> requestResourceResolver = new ThreadLocal();
    private final ClassLoaderWriter classLoaderWriter;

    SlingIOProvider(ClassLoaderWriter classLoaderWriter) {
        this.classLoaderWriter = classLoaderWriter;
    }

    void setRequestResourceResolver(ResourceResolver resolver) {
        this.requestResourceResolver.set(resolver);
    }

    void resetRequestResourceResolver() {
        this.requestResourceResolver.remove();
    }

    @Override
    public InputStream getInputStream(String fileName) throws FileNotFoundException, IOException {
        if (fileName.startsWith(":")) {
            return this.classLoaderWriter.getInputStream(fileName.substring(1));
        }
        try {
            Resource resource = this.getResourceInternal(fileName);
            if (resource == null) {
                throw new FileNotFoundException("Cannot find " + fileName);
            }
            InputStream stream = (InputStream)resource.adaptTo(InputStream.class);
            if (stream == null) {
                throw new FileNotFoundException("Cannot find " + fileName);
            }
            return stream;
        }
        catch (SlingException se) {
            throw (IOException)new IOException("Failed to get InputStream for " + fileName).initCause(se);
        }
    }

    @Override
    public long lastModified(String fileName) {
        if (fileName.startsWith(":")) {
            return this.classLoaderWriter.getLastModified(fileName.substring(1));
        }
        try {
            Resource resource = this.getResourceInternal(fileName);
            if (resource != null) {
                ResourceMetadata meta = resource.getResourceMetadata();
                long modTime = meta.getModificationTime();
                return modTime > 0L ? modTime : 0L;
            }
        }
        catch (SlingException se) {
            this.log.error("Cannot get last modification time for " + fileName, (Throwable)se);
        }
        return -1L;
    }

    @Override
    public boolean delete(String fileName) {
        return this.classLoaderWriter.delete(fileName.substring(1));
    }

    @Override
    public OutputStream getOutputStream(String fileName) {
        return this.classLoaderWriter.getOutputStream(fileName.substring(1));
    }

    @Override
    public boolean rename(String oldFileName, String newFileName) {
        return this.classLoaderWriter.rename(oldFileName.substring(1), newFileName.substring(1));
    }

    @Override
    public boolean mkdirs(String path) {
        return true;
    }

    URL getURL(String path) throws MalformedURLException {
        try {
            Resource resource = this.getResourceInternal(path);
            return resource != null ? (URL)resource.adaptTo(URL.class) : null;
        }
        catch (SlingException se) {
            throw (MalformedURLException)new MalformedURLException("Cannot get URL for " + path).initCause(se);
        }
    }

    Set<String> getResourcePaths(String path) {
        HashSet<String> paths = new HashSet<String>();
        ResourceResolver resolver = this.requestResourceResolver.get();
        if (resolver != null) {
            try {
                String cleanedPath = this.cleanPath(path, false);
                boolean startsWithWebInfTags = cleanedPath.startsWith(WEB_INF_TAGS);
                Resource resource = resolver.getResource(startsWithWebInfTags ? cleanedPath.substring(WEB_INF_TAGS.length()) : cleanedPath);
                if (resource != null) {
                    Iterator entries = resolver.listChildren(resource);
                    while (entries.hasNext()) {
                        String entryPath = ((Resource)entries.next()).getPath();
                        if (startsWithWebInfTags) {
                            paths.add(WEB_INF_TAGS + entryPath);
                            continue;
                        }
                        paths.add(entryPath);
                    }
                }
            }
            catch (SlingException se) {
                this.log.warn("getResourcePaths: Cannot list children of " + path, (Throwable)se);
            }
        }
        return paths.isEmpty() ? null : paths;
    }

    private Resource getResourceInternal(String path) throws SlingException {
        ResourceResolver resolver = this.requestResourceResolver.get();
        if (resolver != null) {
            return resolver.getResource(this.cleanPath(path, true));
        }
        return null;
    }

    private String cleanPath(String path, boolean removeWebInfTags) {
        path = path.replace('\\', '/');
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (removeWebInfTags && path.startsWith(WEB_INF_TAGS)) {
            path = path.substring(WEB_INF_TAGS.length());
        }
        return path;
    }
}

