/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.jasper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface IOProvider {
    public static final IOProvider DEFAULT = new IOProvider(){

        public OutputStream getOutputStream(String fileName) throws IOException {
            File file = new File(fileName);
            file.getParentFile().mkdirs();
            return new FileOutputStream(fileName);
        }

        public InputStream getInputStream(String fileName) throws FileNotFoundException, IOException {
            return new FileInputStream(fileName);
        }

        public boolean delete(String fileName) {
            return new File(fileName).delete();
        }

        public boolean rename(String oldFileName, String newFileName) {
            return new File(oldFileName).renameTo(new File(newFileName));
        }

        public boolean mkdirs(String path) {
            File dirFile = new File(path);
            return dirFile.isDirectory() || dirFile.mkdirs();
        }

        public long lastModified(String path) {
            File checkFile = new File(path);
            return checkFile.exists() ? checkFile.lastModified() : -1L;
        }
    };

    public OutputStream getOutputStream(String var1) throws IOException;

    public InputStream getInputStream(String var1) throws FileNotFoundException, IOException;

    public boolean delete(String var1);

    public boolean rename(String var1, String var2);

    public boolean mkdirs(String var1);

    public long lastModified(String var1);
}

