/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.jasper.compiler;

import java.io.File;
import java.io.FilePermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspEngineInfo;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.sling.scripting.jsp.jasper.Constants;
import org.apache.sling.scripting.jsp.jasper.IOProvider;
import org.apache.sling.scripting.jsp.jasper.Options;
import org.apache.sling.scripting.jsp.jasper.compiler.Localizer;
import org.apache.sling.scripting.jsp.jasper.runtime.JspFactoryImpl;
import org.apache.sling.scripting.jsp.jasper.security.SecurityClassLoad;
import org.apache.sling.scripting.jsp.jasper.servlet.JspCServletContext;
import org.apache.sling.scripting.jsp.jasper.servlet.JspServletWrapper;

public final class JspRuntimeContext {
    private Log log = LogFactory.getLog(JspRuntimeContext.class);
    private int jspReloadCount;
    private IOProvider ioProvider = IOProvider.DEFAULT;
    private static final ThreadLocal<Integer> USE_OWN_FACTORY = new ThreadLocal();
    private ServletContext context;
    private Options options;
    private ClassLoader parentClassLoader;
    private PermissionCollection permissionCollection;
    private CodeSource codeSource;
    private String classpath;
    private Map<String, JspServletWrapper> jsps = new ConcurrentHashMap<String, JspServletWrapper>();
    private Map<String, Set<String>> depToJsp = new HashMap<String, Set<String>>();

    public static JspFactoryHandler initFactoryHandler() {
        JspFactoryImpl factory = new JspFactoryImpl();
        SecurityClassLoad.securityClassLoad(factory.getClass().getClassLoader());
        if (System.getSecurityManager() != null) {
            String basePackage = "org.apache.sling.scripting.jsp.jasper.";
            try {
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary$PrivilegedIntrospectHelper");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.ServletResponseWrapperInclude");
                factory.getClass().getClassLoader().loadClass(basePackage + "servlet.JspServletWrapper");
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
        JspFactoryHandler key = new JspFactoryHandler(JspFactory.getDefaultFactory(), factory);
        JspFactory.setDefaultFactory(key);
        return key;
    }

    public JspRuntimeContext(ServletContext context, Options options) {
        this.context = context;
        this.options = options;
        this.parentClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.parentClassLoader == null) {
            this.parentClassLoader = this.getClass().getClassLoader();
        }
        if (this.log.isDebugEnabled()) {
            if (this.parentClassLoader != null) {
                this.log.debug(Localizer.getMessage("jsp.message.parent_class_loader_is", this.parentClassLoader.toString()));
            } else {
                this.log.debug(Localizer.getMessage("jsp.message.parent_class_loader_is", "<none>"));
            }
        }
        this.initClassPath();
        if (context instanceof JspCServletContext) {
            return;
        }
        if (Constants.IS_SECURITY_ENABLED) {
            this.initSecurity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJspDependencies(JspServletWrapper jsw) {
        List<String> deps = jsw.getDependants();
        if (deps != null) {
            String jspUri = jsw.getJspUri();
            Map<String, Set<String>> map = this.depToJsp;
            synchronized (map) {
                for (String dep : deps) {
                    Set<String> set = this.depToJsp.get(dep);
                    if (set == null) {
                        set = new HashSet<String>();
                        this.depToJsp.put(dep, set);
                    }
                    set.add(jspUri);
                }
            }
        }
    }

    private void invalidate(JspServletWrapper jsw) {
        jsw.clearLastModificationTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleModification(String scriptName) {
        JspRuntimeContext jspRuntimeContext = this;
        synchronized (jspRuntimeContext) {
            JspServletWrapper wrapper = this.jsps.get(scriptName);
            if (wrapper != null) {
                this.invalidate(wrapper);
            }
            if (wrapper == null) {
                Map<String, Set<String>> map = this.depToJsp;
                synchronized (map) {
                    Set<String> deps = this.depToJsp.get(scriptName);
                    if (deps != null) {
                        for (String jspName : deps) {
                            wrapper = this.jsps.get(jspName);
                            if (wrapper == null) continue;
                            this.invalidate(wrapper);
                        }
                    }
                }
            }
        }
    }

    public void addWrapper(String jspUri, JspServletWrapper jsw) {
        this.jsps.put(jspUri, jsw);
    }

    public JspServletWrapper getWrapper(String jspUri) {
        return this.jsps.get(jspUri);
    }

    public JspServletWrapper getAWrapper() {
        if (this.jsps.size() > 0) {
            return this.jsps.values().iterator().next();
        }
        return null;
    }

    public void removeWrapper(String jspUri) {
        this.jsps.remove(jspUri);
    }

    public int getJspCount() {
        return this.jsps.size();
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    public void destroy() {
        Iterator<JspServletWrapper> servlets = this.jsps.values().iterator();
        while (servlets.hasNext()) {
            servlets.next().destroy();
        }
    }

    public synchronized void incrementJspReloadCount() {
        ++this.jspReloadCount;
    }

    public synchronized void setJspReloadCount(int count) {
        this.jspReloadCount = count;
    }

    public int getJspReloadCount() {
        return this.jspReloadCount;
    }

    public String getClassPath() {
        return this.classpath;
    }

    public IOProvider getIOProvider() {
        return this.ioProvider;
    }

    public void setIOProvider(IOProvider ioProvider) {
        this.ioProvider = ioProvider == null ? IOProvider.DEFAULT : ioProvider;
    }

    private void initClassPath() {
        StringBuffer cpath = new StringBuffer();
        String sep = System.getProperty("path.separator");
        if (this.parentClassLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)this.parentClassLoader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                if (!urls[i].getProtocol().equals("file")) continue;
                cpath.append(urls[i].getFile() + sep);
            }
        }
        cpath.append(this.options.getScratchDir() + sep);
        String cp = (String)this.context.getAttribute(Constants.SERVLET_CLASSPATH);
        if (cp == null || cp.equals("")) {
            cp = this.options.getClassPath();
        }
        this.classpath = cpath.toString() + cp;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Compilation classpath initialized: " + this.getClassPath());
        }
    }

    private void initSecurity() {
        Policy policy = Policy.getPolicy();
        if (policy != null) {
            try {
                String codeBase;
                String docBase = this.context.getRealPath("/");
                if (docBase == null) {
                    docBase = this.options.getScratchDir().toString();
                }
                if (!(codeBase = docBase).endsWith(File.separator)) {
                    codeBase = codeBase + File.separator;
                }
                File contextDir = new File(codeBase);
                URL url = contextDir.getCanonicalFile().toURL();
                this.codeSource = new CodeSource(url, (Certificate[])null);
                this.permissionCollection = policy.getPermissions(this.codeSource);
                if (!docBase.endsWith(File.separator)) {
                    this.permissionCollection.add(new FilePermission(docBase, "read"));
                    docBase = docBase + File.separator;
                } else {
                    this.permissionCollection.add(new FilePermission(docBase.substring(0, docBase.length() - 1), "read"));
                }
                docBase = docBase + "-";
                this.permissionCollection.add(new FilePermission(docBase, "read"));
                String workDir = this.options.getScratchDir().toString();
                if (!workDir.endsWith(File.separator)) {
                    this.permissionCollection.add(new FilePermission(workDir, "read"));
                    workDir = workDir + File.separator;
                }
                workDir = workDir + "-";
                this.permissionCollection.add(new FilePermission(workDir, "read"));
                this.permissionCollection.add(new RuntimePermission("accessClassInPackage.org.apache.jasper.runtime"));
                if (this.parentClassLoader instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)this.parentClassLoader).getURLs();
                    String jarUrl = null;
                    String jndiUrl = null;
                    for (int i = 0; i < urls.length; ++i) {
                        if (jndiUrl == null && urls[i].toString().startsWith("jndi:")) {
                            jndiUrl = urls[i].toString() + "-";
                        }
                        if (jarUrl != null || !urls[i].toString().startsWith("jar:jndi:")) continue;
                        jarUrl = urls[i].toString();
                        jarUrl = jarUrl.substring(0, jarUrl.length() - 2);
                        jarUrl = jarUrl.substring(0, jarUrl.lastIndexOf(47)) + "/-";
                    }
                    if (jarUrl != null) {
                        this.permissionCollection.add(new FilePermission(jarUrl, "read"));
                        this.permissionCollection.add(new FilePermission(jarUrl.substring(4), "read"));
                    }
                    if (jndiUrl != null) {
                        this.permissionCollection.add(new FilePermission(jndiUrl, "read"));
                    }
                }
            }
            catch (Exception e) {
                this.context.log("Security Init for context failed", (Throwable)e);
            }
        }
    }

    public static final class JspFactoryHandler
    extends JspFactory {
        private final JspFactory original;
        private final JspFactory own;

        public JspFactoryHandler(JspFactory orig, JspFactory own) {
            this.original = orig instanceof JspFactoryHandler ? ((JspFactoryHandler)orig).original : orig;
            this.own = own;
        }

        private JspFactory getFactory() {
            Integer useOwnFactory = (Integer)USE_OWN_FACTORY.get();
            if (useOwnFactory == null || useOwnFactory == 0) {
                return this.original;
            }
            return this.own;
        }

        public PageContext getPageContext(Servlet paramServlet, ServletRequest paramServletRequest, ServletResponse paramServletResponse, String paramString, boolean paramBoolean1, int paramInt, boolean paramBoolean2) {
            return this.getFactory().getPageContext(paramServlet, paramServletRequest, paramServletResponse, paramString, paramBoolean1, paramInt, paramBoolean2);
        }

        public void releasePageContext(PageContext paramPageContext) {
            this.getFactory().releasePageContext(paramPageContext);
        }

        public JspEngineInfo getEngineInfo() {
            return this.getFactory().getEngineInfo();
        }

        public JspApplicationContext getJspApplicationContext(ServletContext paramServletContext) {
            return this.getFactory().getJspApplicationContext(paramServletContext);
        }

        public void destroy() {
            JspFactory current = JspFactory.getDefaultFactory();
            if (current == this) {
                JspFactory.setDefaultFactory(this.original);
            }
        }

        public void incUsage() {
            Integer count = (Integer)USE_OWN_FACTORY.get();
            int newCount = 1;
            if (count != null) {
                newCount = count + 1;
            }
            USE_OWN_FACTORY.set(newCount);
        }

        public void decUsage() {
            Integer count = (Integer)USE_OWN_FACTORY.get();
            USE_OWN_FACTORY.set(count - 1);
        }

        public int resetUsage() {
            Integer count = (Integer)USE_OWN_FACTORY.get();
            USE_OWN_FACTORY.set(0);
            return count;
        }

        public void setUsage(int count) {
            USE_OWN_FACTORY.set(count);
        }
    }
}

