/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.jasper.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.tagext.TagInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.scripting.ScriptEvaluationException;
import org.apache.sling.commons.classloader.DynamicClassLoader;
import org.apache.sling.scripting.jsp.SlingPageException;
import org.apache.sling.scripting.jsp.jasper.JasperException;
import org.apache.sling.scripting.jsp.jasper.JspCompilationContext;
import org.apache.sling.scripting.jsp.jasper.Options;
import org.apache.sling.scripting.jsp.jasper.compiler.ErrorDispatcher;
import org.apache.sling.scripting.jsp.jasper.compiler.JavacErrorDetail;
import org.apache.sling.scripting.jsp.jasper.compiler.JspRuntimeContext;
import org.apache.sling.scripting.jsp.jasper.compiler.Localizer;
import org.apache.sling.scripting.jsp.jasper.runtime.AnnotationProcessor;
import org.apache.sling.scripting.jsp.jasper.runtime.JspSourceDependent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspServletWrapper {
    private Log log = LogFactory.getLog(JspServletWrapper.class);
    private Servlet theServlet;
    private String jspUri;
    private Class<?> servletClass;
    private Class<?> tagHandlerClass;
    private JspCompilationContext ctxt;
    private long available = 0L;
    private ServletConfig config;
    private Options options;
    private boolean firstTime = true;
    private volatile boolean reload = true;
    private boolean isTagFile;
    private int tripCount;
    private JasperException compileException;
    private long servletClassLastModifiedTime;
    private volatile long lastModificationTest = 0L;

    public JspServletWrapper(ServletConfig config, Options options, String jspUri, boolean isErrorPage, JspRuntimeContext rctxt) throws JasperException {
        this.isTagFile = false;
        this.config = config;
        this.options = options;
        this.jspUri = jspUri;
        this.ctxt = new JspCompilationContext(jspUri, isErrorPage, options, config.getServletContext(), this, rctxt);
    }

    public JspServletWrapper(ServletContext servletContext, Options options, String tagFilePath, TagInfo tagInfo, JspRuntimeContext rctxt, URL tagFileJarUrl) throws JasperException {
        this.isTagFile = true;
        this.config = null;
        this.options = options;
        this.jspUri = tagFilePath;
        this.tripCount = 0;
        this.ctxt = new JspCompilationContext(this.jspUri, tagInfo, options, servletContext, this, rctxt, tagFileJarUrl);
    }

    public JspCompilationContext getJspEngineContext() {
        return this.ctxt;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet getServlet() throws ServletException, IOException, FileNotFoundException {
        if (!this.reload && this.servletClass.getClassLoader() instanceof DynamicClassLoader) {
            boolean bl = this.reload = !((DynamicClassLoader)this.servletClass.getClassLoader()).isLive();
        }
        if (this.reload) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.reload) {
                    this.destroy();
                    Servlet servlet = null;
                    try {
                        this.servletClass = this.ctxt.load();
                        servlet = (Servlet)this.servletClass.newInstance();
                        AnnotationProcessor annotationProcessor = (AnnotationProcessor)this.config.getServletContext().getAttribute(AnnotationProcessor.class.getName());
                        if (annotationProcessor != null) {
                            annotationProcessor.processAnnotations(servlet);
                            annotationProcessor.postConstruct(servlet);
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new JasperException(e);
                    }
                    catch (InstantiationException e) {
                        throw new JasperException(e);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new JasperException(e);
                    }
                    servlet.init(this.config);
                    if (!this.firstTime) {
                        this.ctxt.getRuntimeContext().incrementJspReloadCount();
                    }
                    this.theServlet = servlet;
                    this.reload = false;
                }
            }
        }
        return this.theServlet;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public void setCompilationException(JasperException je) {
        this.compileException = je;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServletClassLastModifiedTime(long lastModified) {
        if (this.servletClassLastModifiedTime < lastModified) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.servletClassLastModifiedTime < lastModified) {
                    this.servletClassLastModifiedTime = lastModified;
                    this.reload = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadTagFile() throws JasperException {
        block17: {
            try {
                JspServletWrapper jspServletWrapper;
                if (this.ctxt.isRemoved()) {
                    throw new FileNotFoundException(this.jspUri);
                }
                if (this.firstTime || this.lastModificationTest <= 0L) {
                    jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        if (this.firstTime || this.lastModificationTest <= 0L) {
                            this.ctxt.compile();
                            this.lastModificationTest = System.currentTimeMillis();
                            this.firstTime = false;
                        } else if (this.compileException != null) {
                            throw this.compileException;
                        }
                    }
                } else if (this.compileException != null) {
                    throw this.compileException;
                }
                if (!this.reload && this.tagHandlerClass.getClassLoader() instanceof DynamicClassLoader) {
                    boolean bl = this.reload = !((DynamicClassLoader)this.tagHandlerClass.getClassLoader()).isLive();
                }
                if (!this.reload) break block17;
                jspServletWrapper = this;
                synchronized (jspServletWrapper) {
                    if (this.reload) {
                        this.tagHandlerClass = this.ctxt.load();
                        this.reload = false;
                    }
                }
            }
            catch (IOException ex) {
                throw new JasperException(ex);
            }
        }
        return this.tagHandlerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadTagFilePrototype() throws JasperException {
        this.ctxt.setPrototypeMode(true);
        try {
            Class<?> clazz = this.loadTagFile();
            return clazz;
        }
        finally {
            this.ctxt.setPrototypeMode(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDependants() {
        try {
            Object target;
            if (this.isTagFile) {
                if (!this.reload && this.tagHandlerClass.getClassLoader() instanceof DynamicClassLoader) {
                    boolean bl = this.reload = !((DynamicClassLoader)this.tagHandlerClass.getClassLoader()).isLive();
                }
                if (this.reload) {
                    JspServletWrapper jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        if (this.reload) {
                            this.tagHandlerClass = this.ctxt.load();
                            this.reload = false;
                        }
                    }
                }
                target = this.tagHandlerClass.newInstance();
            } else {
                target = this.getServlet();
            }
            if (target != null && target instanceof JspSourceDependent) {
                return (List)((JspSourceDependent)target).getDependants();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public int incTripCount() {
        return this.tripCount++;
    }

    public int decTripCount() {
        return this.tripCount--;
    }

    public String getJspUri() {
        return this.jspUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException, FileNotFoundException {
        block35: {
            try {
                if (this.ctxt.isRemoved()) {
                    throw new FileNotFoundException(this.jspUri);
                }
                if (this.available > 0L && this.available < Long.MAX_VALUE) {
                    if (this.available > System.currentTimeMillis()) {
                        response.setDateHeader("Retry-After", this.available);
                        response.sendError(503, Localizer.getMessage("jsp.error.unavailable"));
                        return;
                    }
                    this.available = 0L;
                }
                if (this.firstTime || this.lastModificationTest <= 0L) {
                    JspServletWrapper jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        if (this.firstTime || this.lastModificationTest <= 0L) {
                            this.ctxt.compile();
                            this.lastModificationTest = System.currentTimeMillis();
                            this.firstTime = false;
                        } else if (this.compileException != null) {
                            throw this.compileException;
                        }
                    }
                } else if (this.compileException != null) {
                    throw this.compileException;
                }
                this.getServlet();
                if (precompile) {
                    return;
                }
            }
            catch (FileNotFoundException ex) {
                this.ctxt.incrementRemoved();
                String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                if (includeRequestUri != null) {
                    throw new ServletException((Throwable)ex);
                }
                try {
                    response.sendError(404, ex.getMessage());
                }
                catch (IllegalStateException ise) {
                    this.log.error(Localizer.getMessage("jsp.error.file.not.found", ex.getMessage()), ex);
                }
                return;
            }
            catch (ServletException ex) {
                this.handleJspException((Exception)((Object)ex));
            }
            catch (IOException ex) {
                this.handleJspException(ex);
            }
            catch (IllegalStateException ex) {
                this.handleJspException(ex);
            }
            catch (Exception ex) {
                this.handleJspException(ex);
            }
            try {
                if (this.theServlet instanceof SingleThreadModel) {
                    JspServletWrapper ex = this;
                    synchronized (ex) {
                        this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                        break block35;
                    }
                }
                this.theServlet.service((ServletRequest)request, (ServletResponse)response);
            }
            catch (UnavailableException ex) {
                String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                if (includeRequestUri != null) {
                    throw ex;
                }
                int unavailableSeconds = ex.getUnavailableSeconds();
                if (unavailableSeconds <= 0) {
                    unavailableSeconds = 60;
                }
                this.available = System.currentTimeMillis() + (long)unavailableSeconds * 1000L;
                response.sendError(503, ex.getMessage());
                return;
            }
            catch (ServletException ex) {
                this.handleJspException((Exception)((Object)ex));
            }
            catch (IOException ex) {
                this.handleJspException(ex);
            }
            catch (IllegalStateException ex) {
                this.handleJspException(ex);
            }
            catch (SlingPageException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.handleJspException(ex);
            }
        }
    }

    public void destroy() {
        if (this.theServlet != null) {
            this.theServlet.destroy();
            AnnotationProcessor annotationProcessor = (AnnotationProcessor)this.config.getServletContext().getAttribute(AnnotationProcessor.class.getName());
            if (annotationProcessor != null) {
                try {
                    annotationProcessor.preDestroy(this.theServlet);
                }
                catch (Exception e) {
                    this.log.error(Localizer.getMessage("jsp.error.file.not.found", e.getMessage()), e);
                }
            }
        }
    }

    public long getLastModificationTest() {
        return this.lastModificationTest;
    }

    public void clearLastModificationTest() {
        this.lastModificationTest = -1L;
    }

    protected void handleJspException(Exception ex) throws ServletException {
        Exception jspEx = this.handleJspExceptionInternal(ex);
        if (jspEx instanceof ServletException) {
            throw (ServletException)((Object)jspEx);
        }
        throw (SlingException)((Object)jspEx);
    }

    private Exception handleJspExceptionInternal(Exception ex) throws ServletException {
        Throwable realException = ex;
        String exMessage = "";
        if (ex instanceof ServletException) {
            realException = ((ServletException)((Object)ex)).getRootCause();
            if (realException == null) {
                realException = ex;
            } else {
                exMessage = ex.toString();
            }
        }
        while (realException instanceof ScriptEvaluationException) {
            realException = realException.getCause();
        }
        try {
            StackTraceElement[] frames = realException.getStackTrace();
            StackTraceElement jspFrame = null;
            for (int i = 0; i < frames.length; ++i) {
                if (!frames[i].getClassName().equals(this.getServlet().getClass().getName())) continue;
                jspFrame = frames[i];
                break;
            }
            if (jspFrame == null) {
                if (ex instanceof ServletException) {
                    return ex;
                }
                return new SlingException(ex){};
            }
            int javaLineNumber = jspFrame.getLineNumber();
            JavacErrorDetail detail = ErrorDispatcher.createJavacError(jspFrame.getMethodName(), this.ctxt.getCompiler().getPageNodes(), null, javaLineNumber, this.ctxt);
            int jspLineNumber = detail.getJspBeginLineNumber();
            if (jspLineNumber < 1) {
                if (realException instanceof ServletException) {
                    return (ServletException)realException;
                }
                return new SlingException(exMessage, realException);
            }
            if (this.options.getDisplaySourceFragment() && detail.getJspExtract() != null) {
                return new SlingException(Localizer.getMessage("jsp.exception", detail.getJspFileName(), "" + jspLineNumber) + "\n\n" + detail.getJspExtract() + "\n", realException);
            }
            return new SlingException(Localizer.getMessage("jsp.exception", detail.getJspFileName(), "" + jspLineNumber), realException);
        }
        catch (Exception je) {
            if (realException instanceof ServletException) {
                return (ServletException)realException;
            }
            return new SlingException(exMessage, realException);
        }
    }
}

