/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Dictionary;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingServletException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.jsp.JspServletConfig;
import org.apache.sling.scripting.jsp.JspServletContext;
import org.apache.sling.scripting.jsp.JspServletOptions;
import org.apache.sling.scripting.jsp.SlingIOProvider;
import org.apache.sling.scripting.jsp.SlingPageException;
import org.apache.sling.scripting.jsp.SlingTldLocationsCache;
import org.apache.sling.scripting.jsp.jasper.compiler.JspRuntimeContext;
import org.apache.sling.scripting.jsp.jasper.runtime.AnnotationProcessor;
import org.apache.sling.scripting.jsp.jasper.runtime.JspApplicationContextImpl;
import org.apache.sling.scripting.jsp.jasper.servlet.JspServletWrapper;
import org.apache.sling.scripting.jsp.util.TagUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%jsphandler.name", description="%jsphandler.description", metatype=true)
@Service(value={ScriptEngineFactory.class, EventHandler.class, Servlet.class})
@Properties(value={@Property(name="service.description", value={"JSP Script Handler"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="jasper.compilerTargetVM", value={"auto"}), @Property(name="jasper.compilerSourceVM", value={"auto"}), @Property(name="jasper.classdebuginfo", boolValue={true}), @Property(name="jasper.enablePooling", boolValue={true}), @Property(name="jasper.ieClassId", value={"clsid:8AD9C840-044E-11D1-B3E9-00805F499D93"}), @Property(name="jasper.genStringAsCharArray", boolValue={false}), @Property(name="jasper.keepgenerated", boolValue={true}), @Property(name="jasper.mappedfile", boolValue={true}), @Property(name="jasper.trimSpaces", boolValue={false}), @Property(name="jasper.displaySourceFragments", boolValue={false}), @Property(name="event.topics", value={"org/apache/sling/api/resource/*"}, propertyPrivate=true), @Property(name="felix.webconsole.label", value={"slingjsp"}, propertyPrivate=true), @Property(name="felix.webconsole.title", value={"JSP"}, propertyPrivate=true), @Property(name="felix.webconsole.category", value={"Sling"}, propertyPrivate=true)})
public class JspScriptEngineFactory
extends AbstractScriptEngineFactory
implements EventHandler,
Servlet {
    @Property(boolValue={true})
    private static final String PROP_DEFAULT_IS_SESSION = "default.is.session";
    private final Logger logger = LoggerFactory.getLogger(JspScriptEngineFactory.class);
    @Reference(unbind="unbindSlingServletContext")
    private ServletContext slingServletContext;
    @Reference
    private ClassLoaderWriter classLoaderWriter;
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    private ClassLoader dynamicClassLoader;
    @Reference
    private JavaCompiler javaCompiler;
    private SlingIOProvider ioProvider;
    private SlingTldLocationsCache tldLocationsCache;
    private JspRuntimeContext jspRuntimeContext;
    private JspServletOptions options;
    private JspServletContext jspServletContext;
    private JspServletConfig servletConfig;
    private boolean defaultIsSession;
    private JspRuntimeContext.JspFactoryHandler jspFactoryHandler;
    public static final String[] SCRIPT_TYPE = new String[]{"jsp", "jspf", "jspx"};
    public static final String[] NAMES = new String[]{"jsp", "JSP"};
    private static final String CONFIG_PATH = "/jsp.config";
    private ServletConfig config;

    public JspScriptEngineFactory() {
        this.setExtensions(SCRIPT_TYPE);
        this.setNames(NAMES);
    }

    public ScriptEngine getScriptEngine() {
        return new JspScriptEngine();
    }

    public String getLanguageName() {
        return "Java Server Pages";
    }

    public String getLanguageVersion() {
        return "2.1";
    }

    public Object getParameter(String name) {
        if ("THREADING".equals(name)) {
            return "STATELESS";
        }
        return super.getParameter(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callErrorPageJsp(Bindings bindings, SlingScriptHelper scriptHelper, ScriptContext context, String scriptName) {
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        ResourceResolver resolver = (ResourceResolver)context.getAttribute("org.apache.sling.api.scripting.ScriptResourceResolver", -314);
        if (resolver == null) {
            resolver = scriptHelper.getScript().getScriptResource().getResourceResolver();
        }
        SlingIOProvider io = this.ioProvider;
        JspRuntimeContext.JspFactoryHandler jspfh = this.jspFactoryHandler;
        if (io == null || jspfh == null) {
            this.logger.warn("callJsp: JSP Script Engine seems to be shut down concurrently; not calling {}", (Object)scriptHelper.getScript().getScriptResource().getPath());
            return;
        }
        ResourceResolver oldResolver = io.setRequestResourceResolver(resolver);
        jspfh.incUsage();
        try {
            JspServletWrapper errorJsp = this.getJspWrapper(scriptName, slingBindings);
            errorJsp.service(slingBindings);
            SlingHttpServletRequest request = slingBindings.getRequest();
            Throwable t = (Throwable)request.getAttribute("javax.servlet.jsp.jspException");
            Object newException = request.getAttribute("javax.servlet.error.exception");
            if (newException != null && newException == t) {
                request.removeAttribute("javax.servlet.error.exception");
            }
            request.removeAttribute("javax.servlet.error.status_code");
            request.removeAttribute("javax.servlet.error.request_uri");
            request.removeAttribute("javax.servlet.error.status_code");
            request.removeAttribute("javax.servlet.jsp.jspException");
        }
        finally {
            jspfh.decUsage();
            io.resetRequestResourceResolver(oldResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callJsp(Bindings bindings, SlingScriptHelper scriptHelper, ScriptContext context) {
        ResourceResolver resolver = (ResourceResolver)context.getAttribute("org.apache.sling.api.scripting.ScriptResourceResolver", -314);
        if (resolver == null) {
            resolver = scriptHelper.getScript().getScriptResource().getResourceResolver();
        }
        SlingIOProvider io = this.ioProvider;
        JspRuntimeContext.JspFactoryHandler jspfh = this.jspFactoryHandler;
        if (io == null || jspfh == null) {
            this.logger.warn("callJsp: JSP Script Engine seems to be shut down concurrently; not calling {}", (Object)scriptHelper.getScript().getScriptResource().getPath());
            return;
        }
        ResourceResolver oldResolver = io.setRequestResourceResolver(resolver);
        jspfh.incUsage();
        try {
            SlingBindings slingBindings = new SlingBindings();
            slingBindings.putAll((Map)bindings);
            JspServletWrapper jsp = this.getJspWrapper(scriptHelper, slingBindings);
            jsp.service(slingBindings);
        }
        finally {
            jspfh.decUsage();
            io.resetRequestResourceResolver(oldResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JspServletWrapper getJspWrapper(String scriptName, SlingBindings bindings) throws SlingException {
        JspRuntimeContext rctxt = this.getJspRuntimeContext();
        JspServletWrapper wrapper = rctxt.getWrapper(scriptName);
        if (wrapper != null) {
            if (wrapper.isValid()) {
                return wrapper;
            }
            JspScriptEngineFactory jspScriptEngineFactory = this;
            synchronized (jspScriptEngineFactory) {
                rctxt = this.getJspRuntimeContext();
                wrapper = rctxt.getWrapper(scriptName);
                if (wrapper != null) {
                    if (wrapper.isValid()) {
                        return wrapper;
                    }
                    this.renewJspRuntimeContext();
                    rctxt = this.getJspRuntimeContext();
                }
            }
        }
        wrapper = new JspServletWrapper(this.servletConfig, this.options, scriptName, false, rctxt, this.defaultIsSession);
        wrapper = rctxt.addWrapper(scriptName, wrapper);
        return wrapper;
    }

    private JspServletWrapper getJspWrapper(SlingScriptHelper scriptHelper, SlingBindings bindings) throws SlingException {
        SlingScript script = scriptHelper.getScript();
        String scriptName = script.getScriptResource().getPath();
        return this.getJspWrapper(scriptName, bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        this.defaultIsSession = PropertiesUtil.toBoolean(properties.get(PROP_DEFAULT_IS_SESSION), true);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.dynamicClassLoader);
        try {
            this.jspFactoryHandler = JspRuntimeContext.initFactoryHandler();
            this.tldLocationsCache = new SlingTldLocationsCache(componentContext.getBundleContext());
            this.ioProvider = new SlingIOProvider(this.classLoaderWriter, this.javaCompiler);
            this.options = new JspServletOptions(this.slingServletContext, this.ioProvider, componentContext, this.tldLocationsCache);
            this.jspServletContext = new JspServletContext(this.ioProvider, this.slingServletContext, this.tldLocationsCache);
            this.servletConfig = new JspServletConfig(this.jspServletContext, this.options.getProperties());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        this.checkJasperConfig();
        this.logger.info("Activating Apache Sling Script Engine for JSP with options {}", this.options.getProperties());
        this.logger.debug("IMPORTANT: Do not modify the generated servlet classes directly");
    }

    protected void deactivate(ComponentContext componentContext) {
        this.logger.info("Deactivating Apache Sling Script Engine for JSP");
        if (this.tldLocationsCache != null) {
            this.tldLocationsCache.deactivate(componentContext.getBundleContext());
            this.tldLocationsCache = null;
        }
        if (this.jspRuntimeContext != null) {
            this.destroyJspRuntimeContext(this.jspRuntimeContext);
            this.jspRuntimeContext = null;
        }
        this.ioProvider = null;
        this.jspFactoryHandler.destroy();
        this.jspFactoryHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkJasperConfig() {
        boolean changed = false;
        InputStream is = null;
        try {
            is = this.classLoaderWriter.getInputStream(CONFIG_PATH);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = is.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            baos.close();
            String oldKey = new String(baos.toByteArray(), "UTF-8");
            boolean bl = changed = !oldKey.equals(this.servletConfig.getConfigKey());
            if (changed) {
                this.logger.info("Removing all class files due to jsp configuration change");
            }
        }
        catch (IOException notFound) {
            changed = true;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
        if (changed) {
            OutputStream os = null;
            try {
                os = this.classLoaderWriter.getOutputStream(CONFIG_PATH);
                os.write(this.servletConfig.getConfigKey().getBytes("UTF-8"));
            }
            catch (IOException ignore) {
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            this.classLoaderWriter.delete("/org/apache/jsp");
        }
    }

    protected void unbindSlingServletContext(ServletContext slingServletContext) {
        try {
            if (slingServletContext != null) {
                slingServletContext.removeAttribute(JspApplicationContextImpl.class.getName());
                slingServletContext.removeAttribute(AnnotationProcessor.class.getName());
            }
        }
        catch (NullPointerException npe) {
            this.logger.debug("unbindSlingServletContext: ServletContext might already be unavailable", (Throwable)npe);
        }
        if (this.slingServletContext == slingServletContext) {
            this.slingServletContext = null;
        }
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager rclp) {
        if (this.dynamicClassLoader != null) {
            this.ungetClassLoader();
        }
        this.getClassLoader(rclp);
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager rclp) {
        if (this.dynamicClassLoaderManager == rclp) {
            this.ungetClassLoader();
        }
    }

    private void getClassLoader(DynamicClassLoaderManager rclp) {
        this.dynamicClassLoaderManager = rclp;
        this.dynamicClassLoader = rclp.getDynamicClassLoader();
    }

    private void ungetClassLoader() {
        this.dynamicClassLoader = null;
        this.dynamicClassLoaderManager = null;
    }

    private void destroyJspRuntimeContext(JspRuntimeContext jrc) {
        if (jrc != null) {
            try {
                jrc.destroy();
            }
            catch (NullPointerException npe) {
                this.logger.debug("deactivate: ServletContext might already be unavailable", (Throwable)npe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JspRuntimeContext getJspRuntimeContext() {
        if (this.jspRuntimeContext == null) {
            JspScriptEngineFactory jspScriptEngineFactory = this;
            synchronized (jspScriptEngineFactory) {
                if (this.jspRuntimeContext == null) {
                    this.jspRuntimeContext = new JspRuntimeContext(this.slingServletContext, this.options, this.ioProvider);
                }
            }
        }
        return this.jspRuntimeContext;
    }

    public void handleEvent(Event event) {
        JspRuntimeContext rctxt;
        String path = (String)event.getProperty("path");
        if (path != null && (rctxt = this.jspRuntimeContext) != null && rctxt.handleModification(path)) {
            this.renewJspRuntimeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewJspRuntimeContext() {
        JspRuntimeContext jrc;
        JspScriptEngineFactory jspScriptEngineFactory = this;
        synchronized (jspScriptEngineFactory) {
            jrc = this.jspRuntimeContext;
            this.jspRuntimeContext = null;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                JspScriptEngineFactory.this.destroyJspRuntimeContext(jrc);
            }
        };
        t.start();
    }

    public void destroy() {
        this.config = null;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "";
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            String path = req.getContextPath() + req.getServletPath() + req.getPathInfo();
            if (req.getMethod().equals("POST")) {
                JspRuntimeContext rctxt = this.jspRuntimeContext;
                this.classLoaderWriter.delete("/org/apache/jsp");
                if (rctxt != null) {
                    this.renewJspRuntimeContext();
                }
                res.sendRedirect(path + "?reset");
                return;
            }
            if (req.getMethod().equals("GET")) {
                PrintWriter pw = res.getWriter();
                pw.println("<h1>Apache Sling JSP Scripting</h1>");
                pw.println("<br/>");
                if (req.getParameter("reset") != null) {
                    pw.println("<p>All compiled jsp files removed.");
                    pw.println("<br/>");
                }
                pw.print("<form action='");
                pw.print(path);
                pw.println("' method='POST'>");
                pw.println("<input type='submit' value='Recompile all JSPs'>");
                pw.println("</form>");
                return;
            }
        }
        throw new ServletException("Request not supported.");
    }

    protected void bindSlingServletContext(ServletContext servletContext) {
        this.slingServletContext = servletContext;
    }

    protected void bindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        this.classLoaderWriter = classLoaderWriter;
    }

    protected void unbindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        if (this.classLoaderWriter == classLoaderWriter) {
            this.classLoaderWriter = null;
        }
    }

    protected void bindJavaCompiler(JavaCompiler javaCompiler) {
        this.javaCompiler = javaCompiler;
    }

    protected void unbindJavaCompiler(JavaCompiler javaCompiler) {
        if (this.javaCompiler == javaCompiler) {
            this.javaCompiler = null;
        }
    }

    private static class BetterScriptException
    extends ScriptException {
        private static final long serialVersionUID = -6490165487977283019L;

        public BetterScriptException(String message, Exception cause) {
            super(message);
            this.initCause(cause);
        }
    }

    private class JspScriptEngine
    extends AbstractSlingScriptEngine {
        JspScriptEngine() {
            super((ScriptEngineFactory)((Object)JspScriptEngineFactory.this));
        }

        public Object eval(Reader script, ScriptContext context) throws ScriptException {
            Bindings props = context.getBindings(100);
            SlingScriptHelper scriptHelper = (SlingScriptHelper)props.get("sling");
            if (scriptHelper != null) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(JspScriptEngineFactory.this.dynamicClassLoader);
                try {
                    JspScriptEngineFactory.this.callJsp(props, scriptHelper, context);
                }
                catch (SlingServletException e) {
                    if (e.getCause() != null) {
                        Throwable rootCause = TagUtil.getRootCause((ServletException)e.getCause());
                        if (rootCause instanceof Exception) {
                            throw new BetterScriptException(rootCause.toString(), (Exception)rootCause);
                        }
                        throw new BetterScriptException(rootCause.toString(), new Exception("Wrapping Throwable: " + rootCause.toString(), rootCause));
                    }
                    throw new BetterScriptException(e.getMessage(), (Exception)((Object)e));
                }
                catch (SlingPageException sje) {
                    JspScriptEngineFactory.this.callErrorPageJsp(props, scriptHelper, context, sje.getErrorPage());
                }
                catch (Exception e) {
                    throw new BetterScriptException(e.getMessage(), e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            return null;
        }
    }
}

