/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiled;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.impl.compiled.ExpressionTranslator;
import org.apache.sling.scripting.sightly.impl.compiled.JavaSource;
import org.apache.sling.scripting.sightly.impl.compiled.Type;
import org.apache.sling.scripting.sightly.impl.compiled.VariableDescriptor;
import org.apache.sling.scripting.sightly.impl.compiled.operator.TypedNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.Identifier;
import org.apache.sling.scripting.sightly.impl.compiler.util.expression.SideEffectVisitor;

public class GenHelper {
    private static final Map<Type, String> dynamicCoercions = new HashMap<Type, String>();

    public static void generateTernary(JavaSource source, SideEffectVisitor visitor, TypedNode condition, TypedNode thenBranch, TypedNode elseBranch) {
        source.startExpression();
        GenHelper.typeCoercion(source, visitor, condition, Type.BOOLEAN);
        source.conditional();
        thenBranch.getNode().accept(visitor);
        source.conditionalBranchSep();
        elseBranch.getNode().accept(visitor);
        source.endExpression();
    }

    public static void typeCoercion(JavaSource source, SideEffectVisitor visitor, TypedNode node, Type type) {
        if (type == node.getType() || type == Type.UNKNOWN) {
            node.getNode().accept(visitor);
        } else if (type == Type.LONG && node.getType() == Type.DOUBLE) {
            GenHelper.callLongCoercion(source, visitor, node.getNode());
        } else {
            String coercionMethod = dynamicCoercions.get((Object)type);
            if (coercionMethod == null) {
                throw new UnsupportedOperationException("Cannot generate coercion to type " + (Object)((Object)type));
            }
            GenHelper.callDynamicCoercion(source, visitor, node.getNode(), dynamicCoercions.get((Object)type));
        }
    }

    public static void listCoercion(JavaSource source, ExpressionTranslator visitor, TypedNode typedNode) {
        ExpressionNode node = typedNode.getNode();
        if (node instanceof Identifier) {
            VariableDescriptor descriptor = visitor.getAnalyzer().descriptor(((Identifier)node).getName());
            String listCoercionVar = descriptor.requireListCoercion();
            source.startExpression().append(listCoercionVar).equality().nullLiteral().conditional().startExpression().append(listCoercionVar).assign().startMethodCall("renderContext", "toCollection");
            node.accept(visitor);
            source.endCall().endExpression().conditionalBranchSep().append(listCoercionVar).endExpression();
        } else {
            source.startMethodCall("renderContext", "toCollection");
            typedNode.getNode().accept(visitor);
            source.endCall();
        }
    }

    private static void callLongCoercion(JavaSource source, SideEffectVisitor visitor, ExpressionNode node) {
        source.cast(Type.LONG.getNativeClass());
        source.startExpression();
        node.accept(visitor);
        source.endExpression();
    }

    private static void callDynamicCoercion(JavaSource source, SideEffectVisitor visitor, ExpressionNode node, String methodName) {
        source.startMethodCall("renderContext", methodName);
        node.accept(visitor);
        source.endCall();
    }

    static {
        dynamicCoercions.put(Type.STRING, "toString");
        dynamicCoercions.put(Type.BOOLEAN, "toBoolean");
        dynamicCoercions.put(Type.LONG, "toNumber");
        dynamicCoercions.put(Type.DOUBLE, "toNumber");
    }
}

