/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiled;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.impl.compiled.Type;
import org.apache.sling.scripting.sightly.impl.compiled.TypeInfo;
import org.apache.sling.scripting.sightly.impl.compiled.VariableAnalyzer;
import org.apache.sling.scripting.sightly.impl.compiled.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.Operators;
import org.apache.sling.scripting.sightly.impl.compiled.operator.UnaryOpGen;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.ArrayLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BinaryOperation;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BooleanConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.Identifier;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.MapLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.NullLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.NumericConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.PropertyAccess;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.TernaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.UnaryOperation;

public final class TypeInference
implements NodeVisitor<Type> {
    private final VariableAnalyzer analyzer;
    private final Map<ExpressionNode, Type> inferMap = new IdentityHashMap<ExpressionNode, Type>();

    public static TypeInfo inferTypes(ExpressionNode node, VariableAnalyzer analyzer) {
        TypeInference typeInference = new TypeInference(analyzer);
        typeInference.infer(node);
        return new TypeInfo(typeInference.inferMap);
    }

    private TypeInference(VariableAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    private Type infer(ExpressionNode node) {
        Type type = node.accept(this);
        this.inferMap.put(node, type);
        return type;
    }

    @Override
    public Type evaluate(PropertyAccess propertyAccess) {
        this.infer(propertyAccess.getTarget());
        this.infer(propertyAccess.getProperty());
        return Type.UNKNOWN;
    }

    @Override
    public Type evaluate(Identifier identifier) {
        return this.analyzer.descriptor(identifier.getName()).getType();
    }

    @Override
    public Type evaluate(StringConstant text) {
        return Type.STRING;
    }

    @Override
    public Type evaluate(BinaryOperation binaryOperation) {
        Type leftType = this.infer(binaryOperation.getLeftOperand());
        Type rightType = this.infer(binaryOperation.getRightOperand());
        BinaryOpGen opGen = Operators.generatorFor(binaryOperation.getOperator());
        return opGen.returnType(leftType, rightType);
    }

    @Override
    public Type evaluate(BooleanConstant booleanConstant) {
        return Type.BOOLEAN;
    }

    @Override
    public Type evaluate(NumericConstant numericConstant) {
        Number number = numericConstant.getValue();
        if (number instanceof Integer || number instanceof Long) {
            return Type.LONG;
        }
        if (number instanceof Float || number instanceof Double) {
            return Type.DOUBLE;
        }
        return Type.UNKNOWN;
    }

    @Override
    public Type evaluate(UnaryOperation unaryOperation) {
        this.infer(unaryOperation.getTarget());
        UnaryOpGen opGen = Operators.generatorFor(unaryOperation.getOperator());
        return opGen.returnType(this.infer(unaryOperation.getTarget()));
    }

    @Override
    public Type evaluate(TernaryOperator ternaryOperator) {
        this.infer(ternaryOperator.getCondition());
        Type thenType = this.infer(ternaryOperator.getThenBranch());
        Type elseType = this.infer(ternaryOperator.getElseBranch());
        if (thenType.equals((Object)elseType)) {
            return thenType;
        }
        return Type.UNKNOWN;
    }

    @Override
    public Type evaluate(RuntimeCall runtimeCall) {
        this.inferAll(runtimeCall.getArguments());
        return Type.UNKNOWN;
    }

    @Override
    public Type evaluate(MapLiteral mapLiteral) {
        this.inferAll(mapLiteral.getMap().values());
        return Type.MAP;
    }

    @Override
    public Type evaluate(ArrayLiteral arrayLiteral) {
        this.inferAll(arrayLiteral.getItems());
        return Type.UNKNOWN;
    }

    @Override
    public Type evaluate(NullLiteral nullLiteral) {
        return Type.UNKNOWN;
    }

    private void inferAll(Iterable<ExpressionNode> nodes) {
        for (ExpressionNode node : nodes) {
            this.infer(node);
        }
    }
}

