/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiled;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.sling.scripting.sightly.impl.compiled.Type;
import org.apache.sling.scripting.sightly.impl.compiled.VariableDescriptor;
import org.apache.sling.scripting.sightly.impl.compiled.VariableScope;
import org.apache.sling.scripting.sightly.impl.compiler.SightlyParsingException;
import org.apache.sling.scripting.sightly.impl.compiler.util.VariableTracker;

public class VariableAnalyzer {
    private static final HashSet<String> javaKeywords = new HashSet();
    private final VariableTracker<VariableDescriptor> tracker = new VariableTracker();
    private final List<VariableDescriptor> variables = new ArrayList<VariableDescriptor>();
    private final HashMap<String, VariableDescriptor> dynamicVariables = new HashMap();
    private final HashMap<String, VariableDescriptor> staticVariables = new HashMap();
    private static final String DYNAMIC_PREFIX = "_dynamic_";
    private static final String GLOBAL_PREFIX = "_global_";

    public VariableDescriptor declareVariable(String originalName, Type type) {
        originalName = originalName.toLowerCase();
        String assignedName = this.findSafeName(originalName);
        VariableDescriptor descriptor = new VariableDescriptor(originalName, assignedName, type, VariableScope.SCOPED);
        this.tracker.pushVariable(originalName, descriptor);
        this.variables.add(descriptor);
        return descriptor;
    }

    public VariableDescriptor declareGlobal(String originalName) {
        VariableDescriptor descriptor = this.staticVariables.get(originalName = originalName.toLowerCase());
        if (descriptor == null) {
            String assignedName = this.findGlobalName(originalName);
            descriptor = new VariableDescriptor(originalName, assignedName, Type.UNKNOWN, VariableScope.GLOBAL);
            this.variables.add(descriptor);
            this.staticVariables.put(originalName, descriptor);
        }
        return descriptor;
    }

    public VariableDescriptor declareTemplate(String originalName) {
        originalName = originalName.toLowerCase();
        VariableDescriptor descriptor = this.dynamicDescriptor(originalName);
        descriptor.markAsTemplate();
        return descriptor;
    }

    public VariableDescriptor endVariable() {
        VariableDescriptor descriptor = this.tracker.peek().getValue();
        this.tracker.popVariable();
        return descriptor;
    }

    public VariableDescriptor descriptor(String name) {
        String lowerName = name.toLowerCase();
        VariableDescriptor descriptor = this.tracker.get(lowerName);
        if (descriptor == null) {
            descriptor = this.staticVariables.get(lowerName);
        }
        if (descriptor == null) {
            descriptor = this.dynamicDescriptor(lowerName);
        }
        return descriptor;
    }

    public Collection<VariableDescriptor> allVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public String assignedName(String original) {
        return this.descriptor(original).getAssignedName();
    }

    private VariableDescriptor dynamicDescriptor(String original) {
        VariableDescriptor descriptor = this.dynamicVariables.get(original);
        if (descriptor == null) {
            String dynamicName = this.findDynamicName(this.validName(original));
            descriptor = new VariableDescriptor(original, dynamicName, Type.UNKNOWN, VariableScope.DYNAMIC);
            this.dynamicVariables.put(original, descriptor);
            this.variables.add(descriptor);
        }
        return descriptor;
    }

    private String findDynamicName(String original) {
        return DYNAMIC_PREFIX + this.syntaxSafeName(original);
    }

    private String findGlobalName(String original) {
        return GLOBAL_PREFIX + this.syntaxSafeName(original);
    }

    private String findSafeName(String original) {
        int occurrenceCount = this.tracker.getOccurrenceCount(original);
        String syntaxSafe = this.syntaxSafeName(original);
        if (occurrenceCount == 0) {
            return syntaxSafe;
        }
        return original + "_" + occurrenceCount;
    }

    private String syntaxSafeName(String original) {
        if (javaKeywords.contains(original)) {
            return "_" + original;
        }
        return original.replaceAll("-", "_");
    }

    private String validName(String name) {
        if (name == null || name.contains("-")) {
            throw new SightlyParsingException("Unsupported identifier name: " + name);
        }
        return name.toLowerCase();
    }

    static {
        javaKeywords.add("abstract");
        javaKeywords.add("continue");
        javaKeywords.add("for");
        javaKeywords.add("new");
        javaKeywords.add("switch");
        javaKeywords.add("assert");
        javaKeywords.add("default");
        javaKeywords.add("goto");
        javaKeywords.add("package");
        javaKeywords.add("synchronized");
        javaKeywords.add("boolean");
        javaKeywords.add("do");
        javaKeywords.add("if");
        javaKeywords.add("private");
        javaKeywords.add("this");
        javaKeywords.add("break");
        javaKeywords.add("double");
        javaKeywords.add("implements");
        javaKeywords.add("protected");
        javaKeywords.add("throw");
        javaKeywords.add("byte");
        javaKeywords.add("else");
        javaKeywords.add("import");
        javaKeywords.add("public");
        javaKeywords.add("throws");
        javaKeywords.add("case");
        javaKeywords.add("enum");
        javaKeywords.add("instanceof");
        javaKeywords.add("return");
        javaKeywords.add("transient");
        javaKeywords.add("catch");
        javaKeywords.add("extends");
        javaKeywords.add("int");
        javaKeywords.add("short");
        javaKeywords.add("try");
        javaKeywords.add("char");
        javaKeywords.add("final");
        javaKeywords.add("interface");
        javaKeywords.add("static");
        javaKeywords.add("void");
        javaKeywords.add("class");
        javaKeywords.add("finally");
        javaKeywords.add("long");
        javaKeywords.add("strictfp");
        javaKeywords.add("volatile");
        javaKeywords.add("const");
        javaKeywords.add("float");
        javaKeywords.add("native");
        javaKeywords.add("super");
        javaKeywords.add("while");
    }
}

